/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.async;

import eu.cedarsoft.async.AsynchroniousInvocationException;
import eu.cedarsoft.async.CallbackCaller;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCallSupport<T> {
    @NonNls
    @NotNull
    private static final Log log = LogFactory.getLog(AsyncCallSupport.class);
    @NotNull
    @NonNls
    public static final String NAME_PREFIX = "AsyncWorkerThread ";
    @NotNull
    private final Queue<T> callbacksQueue = new LinkedList<T>();
    @NotNull
    private final Map<T, Object> returnValues = new HashMap<T, Object>();
    @NotNull
    private final Set<T> acks = new HashSet<T>();
    private boolean initialized;
    private transient Thread workerThread;

    public void initializeWorker(@NotNull CallbackCaller<T> callbackCaller) {
        log.debug((Object)("initializeWorker " + callbackCaller));
        this.workerThread = new Thread(new AsyncWorker<T>(this, callbackCaller), NAME_PREFIX + callbackCaller.getDescription() + ' ' + this.hashCode());
        this.workerThread.start();
        this.initialized = true;
    }

    private void initialize() {
    }

    public void shutdown() {
        this.workerThread.interrupt();
    }

    @NotNull
    public <R> R invoke(T callback) throws AsynchroniousInvocationException {
        R value = this.invokeNullable(callback);
        if (value == null) {
            throw new IllegalStateException("Return values was null. Expected not null.");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <R> R invokeNullable(@NotNull T callback) throws AsynchroniousInvocationException {
        long start = System.currentTimeMillis();
        log.debug((Object)("invoking Nullable " + callback));
        log.debug((Object)("Is initialized: " + this.initialized));
        if (!this.isInitialized()) {
            this.initialize();
        }
        Object object = this.callbacksQueue;
        synchronized (object) {
            log.debug((Object)"got Lock on callbacksQueue");
            this.callbacksQueue.add(callback);
            log.debug((Object)"added callback");
            this.callbacksQueue.notifyAll();
            log.debug((Object)("notified callbacks queue (added callback with hash code " + callback.hashCode() + ')'));
        }
        object = this.acks;
        synchronized (object) {
            log.debug((Object)"got log on acks");
            while (!this.acks.remove(callback)) {
                try {
                    log.debug((Object)("waiting for acks - nothing found. " + this.acks.size()));
                    this.acks.wait();
                }
                catch (InterruptedException e) {
                    throw new AsynchroniousInvocationException("Interrupted", e);
                }
            }
        }
        object = this.returnValues;
        synchronized (object) {
            log.debug((Object)"got lock on return values");
            Object returnValue = this.returnValues.remove(callback);
            long end = System.currentTimeMillis();
            log.info((Object)("Database action took " + (end - start) + " ms - returning <" + returnValue + "> for " + callback));
            if (returnValue instanceof Throwable) {
                log.warn((Object)("Wrapping Throwable: " + returnValue));
                throw new AsynchroniousInvocationException((Throwable)returnValue);
            }
            log.debug((Object)("Returning " + returnValue));
            return (R)returnValue;
        }
    }

    public void invokeVoid(@NotNull T callback) throws AsynchroniousInvocationException {
        this.invokeNullable(callback);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected T waitForNextCallback() throws InterruptedException {
        T callback;
        Queue<T> queue = this.callbacksQueue;
        synchronized (queue) {
            log.debug((Object)"got lock on callbacks queue");
            while (this.callbacksQueue.isEmpty()) {
                log.debug((Object)"nothing in callbacksqueue - waiting");
                this.callbacksQueue.wait();
            }
            callback = this.callbacksQueue.poll();
        }
        log.debug((Object)("new callback added - waiting successfull. Returning " + callback));
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledge(@NotNull T action, @Nullable Object returnValue) {
        log.debug((Object)("acknowleding " + action.hashCode() + " with return value " + returnValue));
        Object object = this.returnValues;
        synchronized (object) {
            this.returnValues.put(action, returnValue);
        }
        log.debug((Object)"Added return value");
        object = this.acks;
        synchronized (object) {
            log.debug((Object)"Got Lock on acks");
            int oldSize = this.acks.size();
            this.acks.add(action);
            if (oldSize == this.acks.size()) {
                throw new IllegalStateException("You must not reuse the action " + action + " with return value " + returnValue);
            }
            this.acks.notifyAll();
            log.debug((Object)"notified acks");
        }
    }

    public static void verifyNoWorkerThreadsLeft() throws InterruptedException {
        Thread.sleep(1000L);
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        StringBuilder found = new StringBuilder();
        for (Thread thread : threads) {
            if (!thread.getName().contains(NAME_PREFIX)) continue;
            System.out.println("---> Uups, found one! " + thread);
            found.append("Found remaing thread " + thread + "\n");
        }
        if (found.length() > 0) {
            throw new IllegalThreadStateException(found.toString());
        }
    }

    public static int countWorkerThreadsLeft() throws InterruptedException {
        Thread.sleep(1000L);
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        int count = 0;
        StringBuilder found = new StringBuilder();
        for (Thread thread : threads) {
            if (!thread.getName().contains(NAME_PREFIX)) continue;
            ++count;
        }
        return count;
    }

    public static void shutdownWorkerThreads() throws InterruptedException {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        for (Thread thread : threads) {
            if (!thread.getName().contains(NAME_PREFIX)) continue;
            thread.interrupt();
            thread.stop();
        }
        AsyncCallSupport.verifyNoWorkerThreadsLeft();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AsyncWorker<T>
    implements Runnable {
        private static final Log log = LogFactory.getLog(AsyncWorker.class);
        @NotNull
        private final AsyncCallSupport<T> support;
        @NotNull
        private final CallbackCaller<T> callbackCaller;

        AsyncWorker(@NotNull AsyncCallSupport<T> support, @NotNull CallbackCaller<T> callbackCaller) {
            this.support = support;
            this.callbackCaller = callbackCaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug((Object)"up and running");
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    log.debug((Object)"Thread has been interrupted --> exiting");
                    return;
                }
                try {
                    Object returnValue;
                    log.debug((Object)"waiting for next callback");
                    T callback = this.support.waitForNextCallback();
                    log.debug((Object)"got callback");
                    AsyncCallSupport<T> asyncCallSupport = this.support;
                    synchronized (asyncCallSupport) {
                        returnValue = this.execute(callback);
                    }
                    log.debug((Object)"executed");
                    this.support.acknowledge(callback, returnValue);
                    log.debug((Object)"acknowledged");
                }
                catch (InterruptedException ignore) {
                    log.debug((Object)"Thread has been interrupted --> exiting");
                    return;
                }
            }
        }

        @Nullable
        protected Object execute(@NotNull T callback) {
            Object returnValue;
            long start = System.currentTimeMillis();
            try {
                returnValue = this.callbackCaller.call(callback);
            }
            catch (Throwable e) {
                log.warn((Object)"Got an exception", e);
                returnValue = e;
            }
            long end = System.currentTimeMillis();
            log.info((Object)("Executing callback took " + (end - start) + "ms"));
            return returnValue;
        }
    }
}

