/*
 * Decompiled with CFR 0.152.
 */
package eu.cdevreeze.xpathparser.common;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;

public final class XmlStringUtils$ {
    public static final XmlStringUtils$ MODULE$;

    static {
        new XmlStringUtils$();
    }

    public boolean isProbablyValidXmlName(String s) {
        Predef$.MODULE$.require(s != null);
        return s.length() > 0 && this.isProbableXmlNameStart(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)) && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(1))).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char c) {
                return XmlStringUtils$.MODULE$.eu$cdevreeze$xpathparser$common$XmlStringUtils$$isProbableXmlNameChar(c);
            }
        });
    }

    public boolean containsColon(String s) {
        return s.indexOf(":") >= 0;
    }

    public boolean isAllowedElementLocalName(String s) {
        Predef$.MODULE$.require(s != null);
        return s.length() > 0 && !this.containsColon(s) && this.isProbablyValidXmlName(s);
    }

    public boolean isAllowedPrefix(String s) {
        Predef$.MODULE$.require(s != null);
        return s.length() > 0 && !this.containsColon(s) && this.isProbablyValidXmlName(s);
    }

    public boolean isAllowedOnlyInCData(char c) {
        return c == '<' || c == '&';
    }

    public String escapeText(String s) {
        Predef$.MODULE$.require(s != null);
        return (String)new StringOps(Predef$.MODULE$.augmentString(s)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraversableOnce<Object> apply(char x0$1) {
                StringOps stringOps;
                char c = x0$1;
                switch (c) {
                    default: {
                        stringOps = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{c}));
                        break;
                    }
                    case '\"': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&quot;"));
                        break;
                    }
                    case '\'': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&apos;"));
                        break;
                    }
                    case '>': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&gt;"));
                        break;
                    }
                    case '<': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&lt;"));
                        break;
                    }
                    case '&': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&amp;"));
                    }
                }
                return stringOps;
            }
        }, Predef$.MODULE$.StringCanBuildFrom());
    }

    public String normalizeString(String s) {
        Predef$.MODULE$.require(s != null);
        char[] separators = new char[]{' ', '\t', '\r', '\n'};
        Seq words = (Seq)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(s)).split(separators)).toSeq().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return s.isEmpty();
            }
        });
        return words.mkString(" ");
    }

    private boolean isProbableXmlNameStart(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            default: {
                if (Character.isDigit(c2)) {
                    bl = false;
                    break;
                }
                bl = this.eu$cdevreeze$xpathparser$common$XmlStringUtils$$isProbableXmlNameChar(c);
                break;
            }
            case '.': {
                bl = false;
                break;
            }
            case '-': {
                bl = false;
            }
        }
        return bl;
    }

    public boolean eu$cdevreeze$xpathparser$common$XmlStringUtils$$isProbableXmlNameChar(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            default: {
                if (Character.isWhitespace(c2)) {
                    bl = false;
                    break;
                }
                if (Character.isJavaIdentifierPart(c2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ':': {
                bl = true;
                break;
            }
            case '$': {
                bl = false;
                break;
            }
            case '.': {
                bl = true;
                break;
            }
            case '-': {
                bl = true;
                break;
            }
            case '_': {
                bl = true;
            }
        }
        return bl;
    }

    private XmlStringUtils$() {
        MODULE$ = this;
    }
}

