/*
 * Copyright 2011 Chris de Vreeze
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.cdevreeze

/**
 * Scala wrapper for the Spring `TransactionTemplate`.
 *
 * Knowing the wrapped Spring `TransactionTemplate` API, the Scala wrapper is trivial to use and understand.
 * It is easy to obtain the wrapped Spring counterpart.
 *
 * The Scala wrapper is straightforward idiomatic Scala, in that Spring `TransactionCallback`s are replaced by functions.
 *
 * Examples of using the wrapper (with a plain Spring JdbcTemplate) are:
 * {{{
 * val dutchCities: immutable.IndexedSeq[String] =
 *   txTemplate execute { status =>
 *     val countryCode = "NLD"
 *     val sql = "select name from city where countrycode = ?"
 *     jdbcTemplate.queryForList(sql, classOf[String], countryCode).asScala.toIndexedSeq
 *   }
 *
 * txTemplate executeWithoutResult { status =>
 *   val sql = "update city set population = ? where id = ?"
 *   jdbcTemplate.update(sql, int2Integer(129170), int2Integer(idDenBosch))
 * }
 * }}}
 *
 * Using a JdbcTemplate from the spring-jdbc-scala-utils project, we could simply write:
 * {{{
 * val dutchCities: immutable.IndexedSeq[String] =
 *   txTemplate execute { status =>
 *     val countryCode = "NLD"
 *     val sql = "select name from city where countrycode = ?"
 *     jdbcTemplate.queryForSeq(sql, List(countryCode), classOf[String])
 *   }
 *
 * txTemplate executeWithoutResult { status =>
 *   val sql = "update city set population = ? where id = ?"
 *   jdbcTemplate.update(sql, List(int2Integer(129170), int2Integer(idDenBosch)))
 * }
 * }}}
 *
 * @author Chris de Vreeze
 */
package object springtx
