/*
 * Copyright 2011 Chris de Vreeze
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.cdevreeze

/**
 * Scala wrapper for the Spring `JdbcTemplate`.
 *
 * Example usage:
 * {{{
 * val countryCode = "NLD"
 * val sql = "select name from city where countrycode = ?"
 * val dutchCities = jdbcTemplate.queryForSeq(sql, List(countryCode), classOf[String])
 * }}}
 *
 * Even when using the wrapped Spring `JdbcTemplate`, we can sometimes still use it in a more Scala-esque way. For instance like in this
 * artificial example:
 * {{{
 * import JdbcTemplateUtils._
 *
 * val sql = "select name from city where id = ?"
 *
 * val idDenBosch = 20
 * val action = newPreparedStatementCallback[String] { ps =>
 *   ps.setInt(1, idDenBosch)
 *
 *   var rs: ResultSet = null
 *   try {
 *     rs = ps.executeQuery()
 *     require(rs.next())
 *     rs.getString(1)
 *   } finally {
 *     if (rs ne null) rs.close()
 *   }
 * }
 *
 * val denBosch = jdbcTemplate.wrappedObject.execute(sql, action)
 * }}}
 *
 * @author Chris de Vreeze
 */
package object springjdbc
