/*
 * Decompiled with CFR 0.152.
 */
package eu.bolt.gradle.requiresannotation.processor;

import com.sun.tools.javac.code.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class RequiresAnnotationProcessor
extends AbstractProcessor {
    private static final String PLUGIN_PARAM_EXTRA_PROCESSOR_REQUIRES = "requires";
    private static final String PLUGIN_PARAM_EXTRA_PROCESSOR_IGNORE = "ignore";
    private static final String PLUGIN_PARAM_EXTRA_PROCESSOR_SEPARATOR = "_";
    private static final String REQUIRES_ANNOTATION = "eu.bolt.gradle.requiresannotation.annotation.RequiresAnnotation";
    private static final List<String> IGNORED_ELEMENT_PACKAGES = Arrays.asList("java.lang", "java.util", "android.os", "com.google", "io.reactivex");
    private static final int DEPT_LEVEL_METHOD = 0;
    private static final int DEPT_LEVEL_CLASS = 1;
    private final Map<String, List<String>> extraAnnotationsToScan = new HashMap<String, List<String>>();
    private final List<String> ignoreClassesToScan = new ArrayList<String>();
    private final Pattern regexPatternForGenerics = Pattern.compile("([a-zA-Z0-9_\\.]+)");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Map<String, String> envOptions = processingEnv.getOptions();
        if (envOptions != null) {
            for (String key : envOptions.keySet()) {
                String value = envOptions.get(key);
                if (envOptions.get(key) == null) continue;
                if (key.contains(PLUGIN_PARAM_EXTRA_PROCESSOR_REQUIRES)) {
                    String[] keySplit = key.split(PLUGIN_PARAM_EXTRA_PROCESSOR_SEPARATOR);
                    if (keySplit.length <= 1) continue;
                    this.extraAnnotationsToScan.put(keySplit[1], Arrays.asList(value.split(PLUGIN_PARAM_EXTRA_PROCESSOR_SEPARATOR)));
                    continue;
                }
                if (!key.contains(PLUGIN_PARAM_EXTRA_PROCESSOR_IGNORE)) continue;
                this.ignoreClassesToScan.addAll(Arrays.asList(value.split(PLUGIN_PARAM_EXTRA_PROCESSOR_SEPARATOR)));
            }
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(REQUIRES_ANNOTATION);
        supportedAnnotationTypes.addAll(this.extraAnnotationsToScan.keySet());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv != null) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(this.processingEnv.getElementUtils().getTypeElement(REQUIRES_ANNOTATION));
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    ArrayList<String> requiredAnnotations = new ArrayList<String>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                    if (annotationMirrors != null && !annotationMirrors.isEmpty()) {
                        for (AnnotationMirror annotationMirror : annotationMirrors) {
                            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                            if (elementValues == null || elementValues.isEmpty()) continue;
                            block10: for (ExecutableElement executableElement : elementValues.keySet()) {
                                AnnotationValue annotationValue = elementValues.get(executableElement);
                                switch (executableElement.getSimpleName().toString()) {
                                    case "requires": {
                                        for (Attribute attribute : ((Attribute.Array)annotationValue).values) {
                                            requiredAnnotations.add(attribute.getValue().toString());
                                        }
                                        continue block10;
                                    }
                                    case "ignore": {
                                        for (Attribute attribute : ((Attribute.Array)annotationValue).values) {
                                            arrayList.add(attribute.getValue().toString());
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (requiredAnnotations.isEmpty()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "RequiresAnnotation requires at least one annotation as 'requires'");
                        return false;
                    }
                    this.handleElement(element, requiredAnnotations, arrayList);
                }
            }
            for (String string : this.extraAnnotationsToScan.keySet()) {
                elements = roundEnv.getElementsAnnotatedWith(this.processingEnv.getElementUtils().getTypeElement(string));
                if (elements == null || elements.isEmpty()) continue;
                for (Element element : elements) {
                    this.handleElement(element, this.extraAnnotationsToScan.get(string), this.ignoreClassesToScan);
                }
            }
        }
        return true;
    }

    private void handleElement(Element element, List<String> requiredAnnotations, List<String> ignoreClasses) {
        if (element.getKind() == ElementKind.CLASS) {
            List<ExecutableElement> executableElements = ElementFilter.methodsIn(element.getEnclosedElements());
            if (!executableElements.isEmpty()) {
                for (ExecutableElement executableElement : executableElements) {
                    this.handleMethodElement(executableElement, requiredAnnotations, ignoreClasses, 1);
                }
            }
        } else if (element.getKind() == ElementKind.METHOD) {
            this.handleMethodElement((ExecutableElement)element, requiredAnnotations, ignoreClasses, 0);
        }
    }

    private void handleMethodElement(ExecutableElement execElement, List<String> requiredAnnotations, List<String> ignoreClasses, int deptLevel) {
        ArrayList<String> visitedClassesRecursively = new ArrayList<String>();
        List<? extends VariableElement> parameters = execElement.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (VariableElement variableElement : parameters) {
                this.checkParamElementForAnnotations(execElement, variableElement, requiredAnnotations, ignoreClasses, deptLevel, visitedClassesRecursively);
            }
        }
        this.processTypeElement(execElement, execElement.getReturnType().toString(), requiredAnnotations, ignoreClasses, deptLevel, visitedClassesRecursively);
    }

    private void checkParamElementForAnnotations(ExecutableElement execElement, VariableElement paramElement, List<String> requiredAnnotations, List<String> ignoreClasses, int deptLevel, List<String> visitedClassesRecursively) {
        if (!(paramElement.getModifiers().contains((Object)Modifier.STATIC) || paramElement.getModifiers().contains((Object)Modifier.TRANSIENT) || ignoreClasses.contains(paramElement.getSimpleName().toString()))) {
            if (!(paramElement.asType().getKind().isPrimitive() || this.checkIsJavaTypes(paramElement.asType().toString()) || visitedClassesRecursively.contains(paramElement.asType().toString()))) {
                visitedClassesRecursively.add(paramElement.asType().toString());
                this.processTypeElement(execElement, paramElement.asType().toString(), requiredAnnotations, ignoreClasses, deptLevel, visitedClassesRecursively);
            }
            if (deptLevel > 0) {
                boolean foundRequiredAnnotation = false;
                List<? extends AnnotationMirror> annotationMirrors = paramElement.getAnnotationMirrors();
                if (annotationMirrors != null && !annotationMirrors.isEmpty()) {
                    for (AnnotationMirror annotationMirror : annotationMirrors) {
                        if (!requiredAnnotations.contains(annotationMirror.getAnnotationType().asElement().asType().toString())) continue;
                        foundRequiredAnnotation = true;
                        break;
                    }
                }
                if (!foundRequiredAnnotation) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, paramElement + " at " + execElement + " should have one of these annotations: " + requiredAnnotations, paramElement);
                }
            }
        }
    }

    private void processTypeElement(ExecutableElement execElement, String typeElementStr, List<String> requiredAnnotations, List<String> ignoreClasses, int deptLevel, List<String> visitedClassesRecursively) {
        if (typeElementStr != null) {
            Matcher m = this.regexPatternForGenerics.matcher(typeElementStr);
            while (m.find()) {
                for (int i = 0; i < m.groupCount(); ++i) {
                    List<? extends Element> enclosedElements;
                    TypeElement typeElement;
                    String typeStr = m.group(i);
                    if (this.checkIsJavaTypes(typeStr) || ignoreClasses.contains(typeStr) || (typeElement = this.processingEnv.getElementUtils().getTypeElement(typeStr)) == null || typeElement.getKind() == ElementKind.ENUM || (enclosedElements = typeElement.getEnclosedElements()) == null || enclosedElements.isEmpty()) continue;
                    for (Element element : enclosedElements) {
                        if (element.getKind() != ElementKind.FIELD) continue;
                        this.checkParamElementForAnnotations(execElement, (VariableElement)element, requiredAnnotations, ignoreClasses, deptLevel + 1, visitedClassesRecursively);
                    }
                }
            }
        }
    }

    private boolean checkIsJavaTypes(String packageName) {
        for (String ignoredElementPackage : IGNORED_ELEMENT_PACKAGES) {
            if (!packageName.contains(ignoredElementPackage)) continue;
            return true;
        }
        return false;
    }
}

