/*
 * NetData API
 * Real-time performance and health monitoring.
 *
 * The version of the OpenAPI document: 1.11.1_rolling
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package eu.binjr.sources.netdata.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * ChartSummary
 */
public class ChartSummary {
    public static final String ENDPOINT= "/api/v1/charts";

    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(SERIALIZED_NAME_HOSTNAME)
    private String hostname;

    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(SERIALIZED_NAME_VERSION)
    private String version;

    public static final String SERIALIZED_NAME_RELEASE_CHANNEL = "release_channel";
    @SerializedName(SERIALIZED_NAME_RELEASE_CHANNEL)
    private String releaseChannel;

    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(SERIALIZED_NAME_TIMEZONE)
    private String timezone;

    /**
     * The netdata server host operating system.
     */
    @JsonAdapter(OsEnum.Adapter.class)
    public enum OsEnum {
        MACOS("macos"),

        LINUX("linux"),

        FREEBSD("freebsd");

        private String value;

        OsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static OsEnum fromValue(String value) {
            for (OsEnum b : OsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<OsEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final OsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public OsEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OsEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_OS = "os";
    @SerializedName(SERIALIZED_NAME_OS)
    private OsEnum os;

    public static final String SERIALIZED_NAME_HISTORY = "history";
    @SerializedName(SERIALIZED_NAME_HISTORY)
    private BigDecimal history;

    public static final String SERIALIZED_NAME_MEMORY_MODE = "memory_mode";
    @SerializedName(SERIALIZED_NAME_MEMORY_MODE)
    private String memoryMode;

    public static final String SERIALIZED_NAME_UPDATE_EVERY = "update_every";
    @SerializedName(SERIALIZED_NAME_UPDATE_EVERY)
    private BigDecimal updateEvery;

    public static final String SERIALIZED_NAME_CHARTS = "charts";
    @SerializedName(SERIALIZED_NAME_CHARTS)
    private Map<String, Chart> charts = null;

    public static final String SERIALIZED_NAME_CHARTS_COUNT = "charts_count";
    @SerializedName(SERIALIZED_NAME_CHARTS_COUNT)
    private BigDecimal chartsCount;

    public static final String SERIALIZED_NAME_DIMENSIONS_COUNT = "dimensions_count";
    @SerializedName(SERIALIZED_NAME_DIMENSIONS_COUNT)
    private BigDecimal dimensionsCount;

    public static final String SERIALIZED_NAME_ALARMS_COUNT = "alarms_count";
    @SerializedName(SERIALIZED_NAME_ALARMS_COUNT)
    private BigDecimal alarmsCount;

    public static final String SERIALIZED_NAME_RRD_MEMORY_BYTES = "rrd_memory_bytes";
    @SerializedName(SERIALIZED_NAME_RRD_MEMORY_BYTES)
    private BigDecimal rrdMemoryBytes;


    public ChartSummary hostname(String hostname) {

        this.hostname = hostname;
        return this;
    }

    /**
     * The hostname of the netdata server.
     *
     * @return hostname
     **/
        public String getHostname() {
        return hostname;
    }


    public void setHostname(String hostname) {
        this.hostname = hostname;
    }


    public ChartSummary version(String version) {
        this.version = version;
        return this;
    }

    /**
     * netdata version of the server.
     *
     * @return version
     **/
    
  

    public String getVersion() {
        return version;
    }


    public void setVersion(String version) {
        this.version = version;
    }


    public ChartSummary releaseChannel(String releaseChannel) {
        this.releaseChannel = releaseChannel;
        return this;
    }

    /**
     * The release channel of the build on the server.
     *
     * @return releaseChannel
     **/
    public String getReleaseChannel() {
        return releaseChannel;
    }

    public void setReleaseChannel(String releaseChannel) {
        this.releaseChannel = releaseChannel;
    }

    public ChartSummary timezone(String timezone) {

        this.timezone = timezone;
        return this;
    }

    /**
     * The current timezone on the server.
     *
     * @return timezone
     **/
    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public ChartSummary os(OsEnum os) {

        this.os = os;
        return this;
    }

    /**
     * The netdata server host operating system.
     *
     * @return os
     **/
    public OsEnum getOs() {
        return os;
    }

    public void setOs(OsEnum os) {
        this.os = os;
    }

    public ChartSummary history(BigDecimal history) {

        this.history = history;
        return this;
    }

    /**
     * The duration, in seconds, of the round robin database maintained by netdata.
     *
     * @return history
     **/
    public BigDecimal getHistory() {
        return history;
    }


    public void setHistory(BigDecimal history) {
        this.history = history;
    }


    public ChartSummary memoryMode(String memoryMode) {

        this.memoryMode = memoryMode;
        return this;
    }

    /**
     * The name of the database memory mode on the server.
     *
     * @return memoryMode
     **/
    public String getMemoryMode() {
        return memoryMode;
    }


    public void setMemoryMode(String memoryMode) {
        this.memoryMode = memoryMode;
    }


    public ChartSummary updateEvery(BigDecimal updateEvery) {

        this.updateEvery = updateEvery;
        return this;
    }

    /**
     * The default update frequency of the netdata server. All charts have an update frequency equal or bigger than this.
     *
     * @return updateEvery
     **/
    public BigDecimal getUpdateEvery() {
        return updateEvery;
    }


    public void setUpdateEvery(BigDecimal updateEvery) {
        this.updateEvery = updateEvery;
    }


    public ChartSummary charts(Map<String, Chart> charts) {

        this.charts = charts;
        return this;
    }

    public ChartSummary putChartsItem(String key, Chart chartsItem) {
        if (this.charts == null) {
            this.charts = new HashMap<>();
        }
        this.charts.put(key, chartsItem);
        return this;
    }

    /**
     * An object containing all the chart objects available at the netdata server. This is used as an indexed array. The key of each chart object is the id of the chart.
     *
     * @return charts
     **/
    public Map<String, Chart> getCharts() {
        return charts;
    }


    public void setCharts(Map<String, Chart> charts) {
        this.charts = charts;
    }


    public ChartSummary chartsCount(BigDecimal chartsCount) {

        this.chartsCount = chartsCount;
        return this;
    }

    /**
     * The number of charts.
     *
     * @return chartsCount
     **/
    public BigDecimal getChartsCount() {
        return chartsCount;
    }


    public void setChartsCount(BigDecimal chartsCount) {
        this.chartsCount = chartsCount;
    }


    public ChartSummary dimensionsCount(BigDecimal dimensionsCount) {

        this.dimensionsCount = dimensionsCount;
        return this;
    }

    /**
     * The total number of dimensions.
     *
     * @return dimensionsCount
     **/
    public BigDecimal getDimensionsCount() {
        return dimensionsCount;
    }


    public void setDimensionsCount(BigDecimal dimensionsCount) {
        this.dimensionsCount = dimensionsCount;
    }


    public ChartSummary alarmsCount(BigDecimal alarmsCount) {

        this.alarmsCount = alarmsCount;
        return this;
    }

    /**
     * The number of alarms.
     *
     * @return alarmsCount
     **/
    public BigDecimal getAlarmsCount() {
        return alarmsCount;
    }


    public void setAlarmsCount(BigDecimal alarmsCount) {
        this.alarmsCount = alarmsCount;
    }


    public ChartSummary rrdMemoryBytes(BigDecimal rrdMemoryBytes) {

        this.rrdMemoryBytes = rrdMemoryBytes;
        return this;
    }

    /**
     * The size of the round robin database in bytes.
     *
     * @return rrdMemoryBytes
     **/
    public BigDecimal getRrdMemoryBytes() {
        return rrdMemoryBytes;
    }


    public void setRrdMemoryBytes(BigDecimal rrdMemoryBytes) {
        this.rrdMemoryBytes = rrdMemoryBytes;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChartSummary chartSummary = (ChartSummary) o;
        return Objects.equals(this.hostname, chartSummary.hostname) &&
                Objects.equals(this.version, chartSummary.version) &&
                Objects.equals(this.releaseChannel, chartSummary.releaseChannel) &&
                Objects.equals(this.timezone, chartSummary.timezone) &&
                Objects.equals(this.os, chartSummary.os) &&
                Objects.equals(this.history, chartSummary.history) &&
                Objects.equals(this.memoryMode, chartSummary.memoryMode) &&
                Objects.equals(this.updateEvery, chartSummary.updateEvery) &&
                Objects.equals(this.charts, chartSummary.charts) &&
                Objects.equals(this.chartsCount, chartSummary.chartsCount) &&
                Objects.equals(this.dimensionsCount, chartSummary.dimensionsCount) &&
                Objects.equals(this.alarmsCount, chartSummary.alarmsCount) &&
                Objects.equals(this.rrdMemoryBytes, chartSummary.rrdMemoryBytes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hostname, version, releaseChannel, timezone, os, history, memoryMode, updateEvery, charts, chartsCount, dimensionsCount, alarmsCount, rrdMemoryBytes);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartSummary {\n");
        sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("    releaseChannel: ").append(toIndentedString(releaseChannel)).append("\n");
        sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
        sb.append("    os: ").append(toIndentedString(os)).append("\n");
        sb.append("    history: ").append(toIndentedString(history)).append("\n");
        sb.append("    memoryMode: ").append(toIndentedString(memoryMode)).append("\n");
        sb.append("    updateEvery: ").append(toIndentedString(updateEvery)).append("\n");
        sb.append("    charts: ").append(toIndentedString(charts)).append("\n");
        sb.append("    chartsCount: ").append(toIndentedString(chartsCount)).append("\n");
        sb.append("    dimensionsCount: ").append(toIndentedString(dimensionsCount)).append("\n");
        sb.append("    alarmsCount: ").append(toIndentedString(alarmsCount)).append("\n");
        sb.append("    rrdMemoryBytes: ").append(toIndentedString(rrdMemoryBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

