/*
 * Decompiled with CFR 0.152.
 */
package eu.binjr.sources.netdata.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import eu.binjr.sources.netdata.api.Chart;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ChartSummary {
    public static final String ENDPOINT = "/api/v1/charts";
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_RELEASE_CHANNEL = "release_channel";
    @SerializedName(value="release_channel")
    private String releaseChannel;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone;
    public static final String SERIALIZED_NAME_OS = "os";
    @SerializedName(value="os")
    private OsEnum os;
    public static final String SERIALIZED_NAME_HISTORY = "history";
    @SerializedName(value="history")
    private BigDecimal history;
    public static final String SERIALIZED_NAME_MEMORY_MODE = "memory_mode";
    @SerializedName(value="memory_mode")
    private String memoryMode;
    public static final String SERIALIZED_NAME_UPDATE_EVERY = "update_every";
    @SerializedName(value="update_every")
    private BigDecimal updateEvery;
    public static final String SERIALIZED_NAME_CHARTS = "charts";
    @SerializedName(value="charts")
    private Map<String, Chart> charts = null;
    public static final String SERIALIZED_NAME_CHARTS_COUNT = "charts_count";
    @SerializedName(value="charts_count")
    private BigDecimal chartsCount;
    public static final String SERIALIZED_NAME_DIMENSIONS_COUNT = "dimensions_count";
    @SerializedName(value="dimensions_count")
    private BigDecimal dimensionsCount;
    public static final String SERIALIZED_NAME_ALARMS_COUNT = "alarms_count";
    @SerializedName(value="alarms_count")
    private BigDecimal alarmsCount;
    public static final String SERIALIZED_NAME_RRD_MEMORY_BYTES = "rrd_memory_bytes";
    @SerializedName(value="rrd_memory_bytes")
    private BigDecimal rrdMemoryBytes;

    public ChartSummary hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ChartSummary version(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ChartSummary releaseChannel(String releaseChannel) {
        this.releaseChannel = releaseChannel;
        return this;
    }

    public String getReleaseChannel() {
        return this.releaseChannel;
    }

    public void setReleaseChannel(String releaseChannel) {
        this.releaseChannel = releaseChannel;
    }

    public ChartSummary timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public ChartSummary os(OsEnum os) {
        this.os = os;
        return this;
    }

    public OsEnum getOs() {
        return this.os;
    }

    public void setOs(OsEnum os) {
        this.os = os;
    }

    public ChartSummary history(BigDecimal history) {
        this.history = history;
        return this;
    }

    public BigDecimal getHistory() {
        return this.history;
    }

    public void setHistory(BigDecimal history) {
        this.history = history;
    }

    public ChartSummary memoryMode(String memoryMode) {
        this.memoryMode = memoryMode;
        return this;
    }

    public String getMemoryMode() {
        return this.memoryMode;
    }

    public void setMemoryMode(String memoryMode) {
        this.memoryMode = memoryMode;
    }

    public ChartSummary updateEvery(BigDecimal updateEvery) {
        this.updateEvery = updateEvery;
        return this;
    }

    public BigDecimal getUpdateEvery() {
        return this.updateEvery;
    }

    public void setUpdateEvery(BigDecimal updateEvery) {
        this.updateEvery = updateEvery;
    }

    public ChartSummary charts(Map<String, Chart> charts) {
        this.charts = charts;
        return this;
    }

    public ChartSummary putChartsItem(String key, Chart chartsItem) {
        if (this.charts == null) {
            this.charts = new HashMap<String, Chart>();
        }
        this.charts.put(key, chartsItem);
        return this;
    }

    public Map<String, Chart> getCharts() {
        return this.charts;
    }

    public void setCharts(Map<String, Chart> charts) {
        this.charts = charts;
    }

    public ChartSummary chartsCount(BigDecimal chartsCount) {
        this.chartsCount = chartsCount;
        return this;
    }

    public BigDecimal getChartsCount() {
        return this.chartsCount;
    }

    public void setChartsCount(BigDecimal chartsCount) {
        this.chartsCount = chartsCount;
    }

    public ChartSummary dimensionsCount(BigDecimal dimensionsCount) {
        this.dimensionsCount = dimensionsCount;
        return this;
    }

    public BigDecimal getDimensionsCount() {
        return this.dimensionsCount;
    }

    public void setDimensionsCount(BigDecimal dimensionsCount) {
        this.dimensionsCount = dimensionsCount;
    }

    public ChartSummary alarmsCount(BigDecimal alarmsCount) {
        this.alarmsCount = alarmsCount;
        return this;
    }

    public BigDecimal getAlarmsCount() {
        return this.alarmsCount;
    }

    public void setAlarmsCount(BigDecimal alarmsCount) {
        this.alarmsCount = alarmsCount;
    }

    public ChartSummary rrdMemoryBytes(BigDecimal rrdMemoryBytes) {
        this.rrdMemoryBytes = rrdMemoryBytes;
        return this;
    }

    public BigDecimal getRrdMemoryBytes() {
        return this.rrdMemoryBytes;
    }

    public void setRrdMemoryBytes(BigDecimal rrdMemoryBytes) {
        this.rrdMemoryBytes = rrdMemoryBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartSummary chartSummary = (ChartSummary)o;
        return Objects.equals(this.hostname, chartSummary.hostname) && Objects.equals(this.version, chartSummary.version) && Objects.equals(this.releaseChannel, chartSummary.releaseChannel) && Objects.equals(this.timezone, chartSummary.timezone) && Objects.equals((Object)this.os, (Object)chartSummary.os) && Objects.equals(this.history, chartSummary.history) && Objects.equals(this.memoryMode, chartSummary.memoryMode) && Objects.equals(this.updateEvery, chartSummary.updateEvery) && Objects.equals(this.charts, chartSummary.charts) && Objects.equals(this.chartsCount, chartSummary.chartsCount) && Objects.equals(this.dimensionsCount, chartSummary.dimensionsCount) && Objects.equals(this.alarmsCount, chartSummary.alarmsCount) && Objects.equals(this.rrdMemoryBytes, chartSummary.rrdMemoryBytes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostname, this.version, this.releaseChannel, this.timezone, this.os, this.history, this.memoryMode, this.updateEvery, this.charts, this.chartsCount, this.dimensionsCount, this.alarmsCount, this.rrdMemoryBytes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartSummary {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    releaseChannel: ").append(this.toIndentedString(this.releaseChannel)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    os: ").append(this.toIndentedString((Object)this.os)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    memoryMode: ").append(this.toIndentedString(this.memoryMode)).append("\n");
        sb.append("    updateEvery: ").append(this.toIndentedString(this.updateEvery)).append("\n");
        sb.append("    charts: ").append(this.toIndentedString(this.charts)).append("\n");
        sb.append("    chartsCount: ").append(this.toIndentedString(this.chartsCount)).append("\n");
        sb.append("    dimensionsCount: ").append(this.toIndentedString(this.dimensionsCount)).append("\n");
        sb.append("    alarmsCount: ").append(this.toIndentedString(this.alarmsCount)).append("\n");
        sb.append("    rrdMemoryBytes: ").append(this.toIndentedString(this.rrdMemoryBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OsEnum {
        MACOS("macos"),
        LINUX("linux"),
        FREEBSD("freebsd");

        private String value;

        private OsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OsEnum fromValue(String value) {
            for (OsEnum b : OsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OsEnum> {
            public void write(JsonWriter jsonWriter, OsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OsEnum.fromValue(value);
            }
        }
    }
}

