/*
 * Decompiled with CFR 0.152.
 */
package eu.binjr.sources.netdata.adapters;

import com.google.gson.Gson;
import eu.binjr.common.javafx.controls.TimeRange;
import eu.binjr.core.data.adapters.DataAdapter;
import eu.binjr.core.data.adapters.HttpDataAdapter;
import eu.binjr.core.data.adapters.TimeSeriesBinding;
import eu.binjr.core.data.adapters.TimeSeriesBindingBuilder;
import eu.binjr.core.data.adapters.UriParameter;
import eu.binjr.core.data.codec.Decoder;
import eu.binjr.core.data.codec.csv.CsvDecoder;
import eu.binjr.core.data.exceptions.CannotInitializeDataAdapterException;
import eu.binjr.core.data.exceptions.DataAdapterException;
import eu.binjr.core.data.timeseries.DoubleTimeSeriesProcessor;
import eu.binjr.core.data.workspace.ChartType;
import eu.binjr.core.data.workspace.TimeSeriesInfo;
import eu.binjr.core.preferences.UserPreferences;
import eu.binjr.sources.netdata.adapters.NetdataAdapterPreferences;
import eu.binjr.sources.netdata.api.Chart;
import eu.binjr.sources.netdata.api.ChartSummary;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.fx.ui.controls.tree.FilterableTreeItem;

public class NetdataAdapter
extends HttpDataAdapter {
    private static final Logger logger = LogManager.getLogger(NetdataAdapter.class);
    private static final char DELIMITER = ',';
    private ZoneId zoneId;
    private final Gson jsonParser;
    private Decoder decoder;
    private UserPreferences userPrefs = UserPreferences.getInstance();
    private NetdataAdapterPreferences adapterPrefs = (NetdataAdapterPreferences)this.getAdapterInfo().getPreferences();

    public NetdataAdapter() throws CannotInitializeDataAdapterException {
        this(null, ZoneId.systemDefault());
    }

    private NetdataAdapter(URL baseAddress, ZoneId zoneId) throws CannotInitializeDataAdapterException {
        super(baseAddress);
        this.zoneId = zoneId;
        this.decoder = this.buildDecoder(zoneId);
        this.jsonParser = new Gson();
    }

    public static DataAdapter fromUrl(String address, ZoneId zoneId) throws CannotInitializeDataAdapterException {
        return new NetdataAdapter(NetdataAdapter.urlFromString((String)address), zoneId);
    }

    protected URI craftFetchUri(String path, Instant begin, Instant end) throws DataAdapterException {
        ArrayList<UriParameter> params = new ArrayList<UriParameter>();
        params.add(UriParameter.of((String)"points", (Object)((Boolean)this.userPrefs.downSamplingEnabled.get() != false && (Boolean)this.adapterPrefs.disableServerSideDownsampling.get() == false ? this.userPrefs.downSamplingThreshold.get() : this.adapterPrefs.maxSamplesAllowed.get())));
        params.add(UriParameter.of((String)"group", (Object)this.adapterPrefs.groupingMethod.get()));
        params.add(UriParameter.of((String)"gtime", (Object)this.adapterPrefs.groupingTime.get()));
        if (((Boolean)this.adapterPrefs.disableTimeFrameAlignment.get()).booleanValue()) {
            params.add(UriParameter.of((String)"options", (Object)"unaligned"));
        }
        params.add(UriParameter.of((String)"format", (Object)"csv"));
        params.add(UriParameter.of((String)"options", (Object)"seconds"));
        params.add(UriParameter.of((String)"after", (Object)(begin.getEpochSecond() - (long)((Number)this.adapterPrefs.fetchReadBehindSeconds.get()).intValue())));
        params.add(UriParameter.of((String)"before", (Object)(end.getEpochSecond() + (long)((Number)this.adapterPrefs.fetchReadAheadSeconds.get()).intValue())));
        return this.craftRequestUri(path, params);
    }

    public boolean isSortingRequired() {
        return true;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public FilterableTreeItem<TimeSeriesBinding> getBindingTree() throws DataAdapterException {
        ChartSummary chartSummary = (ChartSummary)this.doHttpGet(this.craftRequestUri("/api/v1/charts", new NameValuePair[0]), response -> (ChartSummary)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), ChartSummary.class));
        FilterableTreeItem tree = new FilterableTreeItem((Object)new TimeSeriesBindingBuilder((DataAdapter)this).setLabel(this.getSourceName()).setParent("").setPath("/").build());
        TreeMap types = new TreeMap();
        chartSummary.getCharts().forEach((s, chart) -> {
            String categoryName = this.getCategoryName((Chart)chart);
            FilterableTreeItem categoryBranch = types.computeIfAbsent(categoryName, s1 -> new FilterableTreeItem((Object)new TimeSeriesBindingBuilder((DataAdapter)this).setPath("").setLabel(categoryName).setParent(((TimeSeriesBinding)tree.getValue()).getTreeHierarchy()).build()));
            FilterableTreeItem branch = new FilterableTreeItem((Object)new TimeSeriesBindingBuilder((DataAdapter)this).setPath(chart.getDataUrl()).setLabel(chart.getName()).setGraphType(ChartType.valueOrDefault((String)chart.getChartType().name(), (ChartType)ChartType.STACKED)).setLegend(chart.getTitle()).setUnitName(chart.getUnits()).setParent(((TimeSeriesBinding)categoryBranch.getValue()).getTreeHierarchy()).build());
            chart.getDimensions().forEach((s1, chartDimensions) -> branch.getInternalChildren().add(0, (Object)new FilterableTreeItem((Object)new TimeSeriesBindingBuilder((DataAdapter)this).setLabel(chartDimensions.getName()).setParent(((TimeSeriesBinding)branch.getValue()).getTreeHierarchy()).setUnitName(chart.getUnits()).setGraphType(ChartType.valueOrDefault((String)chart.getChartType().name(), (ChartType)ChartType.STACKED)).setPath(chart.getDataUrl()).build())));
            categoryBranch.getInternalChildren().add((Object)branch);
        });
        tree.getInternalChildren().addAll(types.values());
        return tree;
    }

    public String getEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public ZoneId getTimeZoneId() {
        return this.zoneId;
    }

    public TimeRange getInitialTimeRange(String path, List<TimeSeriesInfo> seriesInfo) throws DataAdapterException {
        Chart chart = (Chart)this.doHttpGet(this.craftRequestUri(path.replace("/data?", "/chart?"), new NameValuePair[0]), response -> (Chart)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), Chart.class));
        return TimeRange.of((ZonedDateTime)ZonedDateTime.ofInstant(Instant.ofEpochSecond(chart.getFirstEntry().longValue()), this.zoneId), (ZonedDateTime)ZonedDateTime.ofInstant(Instant.ofEpochSecond(chart.getLastEntry().longValue()), this.zoneId));
    }

    public String getSourceName() {
        return "[Netdata] " + (this.getBaseAddress() != null ? this.getBaseAddress().getHost() : "???") + (String)(this.getBaseAddress() != null && this.getBaseAddress().getPort() > 0 ? ":" + this.getBaseAddress().getPort() : "") + " - " + " (" + (this.zoneId != null ? this.zoneId : "???") + ")";
    }

    private CsvDecoder buildDecoder(ZoneId zoneId) {
        return new CsvDecoder(this.getEncoding(), ',', DoubleTimeSeriesProcessor::new, s -> Instant.ofEpochSecond(Long.parseLong(s)).atZone(zoneId));
    }

    private String getCategoryName(Chart chart) {
        String categoryName = chart.getType().split("_")[0];
        return categoryName.isBlank() ? "Unknown" : categoryName.substring(0, 1).toUpperCase() + categoryName.substring(1);
    }
}

