/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

import java.util.EnumSet;
import java.util.Objects;

public class PollFD {
    private final int fd;
    private final EnumSet<PollEvent> events;
    private final EnumSet<PollEvent> revents;

    public PollFD(int fd, EnumSet<PollEvent> events) {
        this.fd = fd;
        this.events = Objects.requireNonNull(events);
        this.revents = EnumSet.noneOf(PollEvent.class);
    }

    public int getFd() {
        return this.fd;
    }

    public EnumSet<PollEvent> getEvents() {
        return this.events;
    }

    public EnumSet<PollEvent> getREvents() {
        return this.revents;
    }

    public boolean test(PollEvent event) {
        return event != null && this.revents.contains((Object)event);
    }

    public static enum PollEvent {
        POLLIN,
        POLLPRI,
        POLLOUT,
        POLLRDNORM,
        POLLRDBAND,
        POLLWRNORM,
        POLLWRBAND,
        POLLMSG,
        POLLREMOVE,
        POLLRDHUP,
        POLLERR,
        POLLHUP,
        POLLNVAL;

    }
}

