/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

public class GUID {
    private int data1;
    private short data2;
    private short data3;
    private final byte[] data4 = new byte[8];

    public GUID() {
    }

    public GUID(String txt) {
        if (txt.length() != 36) {
            throw new IllegalArgumentException("Invalid GUID");
        }
        txt = txt.toUpperCase();
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (!(i == 8 || i == 13 || i == 18 || i == 23 ? c != '-' : !Character.isDigit(c) && (c < 'A' || c > 'F'))) continue;
            throw new IllegalArgumentException("Invalid GUID");
        }
        try {
            this.data1 = (int)Long.parseLong(txt.substring(0, 8), 16);
            this.data2 = (short)Long.parseLong(txt.substring(9, 13), 16);
            this.data3 = (short)Long.parseLong(txt.substring(14, 18), 16);
            this.data4[0] = (byte)Long.parseLong(txt.substring(19, 21), 16);
            this.data4[1] = (byte)Long.parseLong(txt.substring(21, 23), 16);
            this.data4[2] = (byte)Long.parseLong(txt.substring(24, 26), 16);
            this.data4[3] = (byte)Long.parseLong(txt.substring(26, 28), 16);
            this.data4[4] = (byte)Long.parseLong(txt.substring(28, 30), 16);
            this.data4[5] = (byte)Long.parseLong(txt.substring(30, 32), 16);
            this.data4[6] = (byte)Long.parseLong(txt.substring(32, 34), 16);
            this.data4[7] = (byte)Long.parseLong(txt.substring(34, 36), 16);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("Invalid GUID", exc);
        }
    }

    public int getData1() {
        return this.data1;
    }

    public void setData1(int data1) {
        this.data1 = data1;
    }

    public short getData2() {
        return this.data2;
    }

    public void setData2(short data2) {
        this.data2 = data2;
    }

    public short getData3() {
        return this.data3;
    }

    public void setData3(short data3) {
        this.data3 = data3;
    }

    public byte[] getData4() {
        return this.data4;
    }

    public void setData4(byte[] data4) {
        System.arraycopy(data4, 0, this.data4, 0, 8);
    }

    public String toString() {
        String s1 = Long.toHexString((long)this.data1 & 0xFFFFFFFFL);
        String s2 = Long.toHexString(this.data2 & 0xFFFF);
        String s3 = Long.toHexString(this.data3 & 0xFFFF);
        StringBuilder s4 = new StringBuilder();
        for (int i = 0; i < this.data4.length; ++i) {
            String s = Long.toHexString(this.data4[i] & 0xFF);
            if (s.length() == 1) {
                s4.append("0");
            }
            s4.append(s);
        }
        while (s1.length() < 8) {
            s1 = "0" + s1;
        }
        while (s2.length() < 4) {
            s2 = "0" + s2;
        }
        while (s3.length() < 4) {
            s3 = "0" + s3;
        }
        return (s1 + "-" + s2 + "-" + s3 + "-" + s4.substring(0, 4) + "-" + s4.substring(4)).toUpperCase();
    }

    public GUID clone() {
        GUID clone = new GUID();
        clone.data1 = this.data1;
        clone.data2 = this.data2;
        clone.data3 = this.data3;
        System.arraycopy(this.data4, 0, clone.data4, 0, 8);
        return clone;
    }
}

