/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client.transformer;

import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.messages.AntidoteResponse;
import eu.antidotedb.client.transformer.Transformer;
import eu.antidotedb.client.transformer.TransformerFactory;
import eu.antidotedb.client.transformer.TransformerWithDownstream;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingTransformer
implements TransformerFactory {
    private AtomicInteger readObjectsCounter = new AtomicInteger(0);
    private AtomicInteger updateObjectsCounter = new AtomicInteger(0);
    private AtomicInteger startTransactionCounter = new AtomicInteger(0);
    private AtomicInteger abortTransactionCounter = new AtomicInteger(0);
    private AtomicInteger commitTransactionCounter = new AtomicInteger(0);
    private AtomicInteger staticReadsCounter = new AtomicInteger(0);
    private AtomicInteger staticUpdatesCounter = new AtomicInteger(0);

    public int getReadObjectsCounter() {
        return this.readObjectsCounter.get();
    }

    public int getUpdateObjectsCounter() {
        return this.updateObjectsCounter.get();
    }

    public int getStartTransactionCounter() {
        return this.startTransactionCounter.get();
    }

    public int getAbortTransactionCounter() {
        return this.abortTransactionCounter.get();
    }

    public int getCommitTransactionCounter() {
        return this.commitTransactionCounter.get();
    }

    public int getStaticReadsCounter() {
        return this.staticReadsCounter.get();
    }

    public int getStaticUpdatesCounter() {
        return this.staticUpdatesCounter.get();
    }

    @Override
    public Transformer newTransformer(Transformer downstream, Connection connection) {
        return new TransformerWithDownstream(downstream){

            @Override
            public AntidoteResponse handle(AntidotePB.ApbReadObjects op) {
                CountingTransformer.this.readObjectsCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbUpdateObjects op) {
                CountingTransformer.this.updateObjectsCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbStartTransaction op) {
                CountingTransformer.this.startTransactionCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbAbortTransaction op) {
                CountingTransformer.this.abortTransactionCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbCommitTransaction op) {
                CountingTransformer.this.commitTransactionCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbStaticReadObjects op) {
                CountingTransformer.this.staticReadsCounter.incrementAndGet();
                return super.handle(op);
            }

            @Override
            public AntidoteResponse handle(AntidotePB.ApbStaticUpdateObjects op) {
                CountingTransformer.this.staticUpdatesCounter.incrementAndGet();
                return super.handle(op);
            }
        };
    }
}

