/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface ValueCoder<T> {
    public static final ValueCoder<String> utf8String = new ValueCoder<String>(){

        @Override
        public ByteString encode(String value) {
            return ByteString.copyFromUtf8((String)value);
        }

        @Override
        public String decode(ByteString bytes) {
            return bytes.toStringUtf8();
        }
    };
    public static final ValueCoder<ByteString> bytestringEncoder = new ValueCoder<ByteString>(){

        @Override
        public ByteString encode(ByteString value) {
            return value;
        }

        @Override
        public ByteString decode(ByteString bytes) {
            return bytes;
        }

        @Override
        public List<ByteString> encodeList(List<ByteString> valueList) {
            return valueList;
        }

        @Override
        public List<ByteString> decodeList(List<ByteString> byteStringList) {
            return byteStringList;
        }
    };
    public static final ValueCoder<Integer> integerCoder = new ValueCoder<Integer>(){

        @Override
        public ByteString encode(Integer value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(value);
            buffer.flip();
            return ByteString.copyFrom((ByteBuffer)buffer);
        }

        @Override
        public Integer decode(ByteString bytes) {
            if (bytes.isEmpty()) {
                return 0;
            }
            return bytes.asReadOnlyByteBuffer().getInt();
        }
    };
    public static final ValueCoder<Long> longCoder = new ValueCoder<Long>(){

        @Override
        public ByteString encode(Long value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(value);
            buffer.flip();
            return ByteString.copyFrom((ByteBuffer)buffer);
        }

        @Override
        public Long decode(ByteString bytes) {
            if (bytes.isEmpty()) {
                return 0L;
            }
            return bytes.asReadOnlyByteBuffer().getLong();
        }
    };
    public static final ValueCoder<Float> floatCoder = new ValueCoder<Float>(){

        @Override
        public ByteString encode(Float value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putFloat(value.floatValue());
            buffer.flip();
            return ByteString.copyFrom((ByteBuffer)buffer);
        }

        @Override
        public Float decode(ByteString bytes) {
            if (bytes.isEmpty()) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(bytes.asReadOnlyByteBuffer().getFloat());
        }
    };
    public static final ValueCoder<Double> doubleCoder = new ValueCoder<Double>(){

        @Override
        public ByteString encode(Double value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putDouble(value);
            buffer.flip();
            return ByteString.copyFrom((ByteBuffer)buffer);
        }

        @Override
        public Double decode(ByteString bytes) {
            if (bytes.isEmpty()) {
                return 0.0;
            }
            return bytes.asReadOnlyByteBuffer().getDouble();
        }
    };

    public ByteString encode(T var1);

    public T decode(ByteString var1);

    default public List<T> decodeList(List<ByteString> byteStringList) {
        return byteStringList.stream().map(this::decode).collect(Collectors.toList());
    }

    default public List<ByteString> encodeList(List<T> valueList) {
        return valueList.stream().map(this::encode).collect(Collectors.toList());
    }

    public static <T> ValueCoder<T> byteCoder(final Function<T, ByteString> toBytestring, final Function<ByteString, T> fromBytestring) {
        return new ValueCoder<T>(){

            @Override
            public ByteString encode(T value) {
                return (ByteString)toBytestring.apply(value);
            }

            @Override
            public T decode(ByteString bytes) {
                return fromBytestring.apply(bytes);
            }
        };
    }

    public static <T> ValueCoder<T> stringCoder(final Function<T, String> toString, final Function<String, T> fromString) {
        return new ValueCoder<T>(){

            @Override
            public ByteString encode(T value) {
                return ByteString.copyFromUtf8((String)((String)toString.apply(value)));
            }

            @Override
            public T decode(ByteString bytes) {
                return fromString.apply(bytes.toStringUtf8());
            }
        };
    }
}

