/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.ApbCoder;
import eu.antidotedb.client.messages.AntidoteResponse;
import eu.antidotedb.client.transformer.Transformer;
import java.io.IOException;
import java.net.Socket;

class SocketSender
implements Transformer {
    private Socket socket;

    public SocketSender(Socket s) {
        this.socket = s;
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbReadObjects op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbUpdateObjects op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbStartTransaction op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbAbortTransaction op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbCommitTransaction op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbStaticReadObjects op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbStaticUpdateObjects op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbCreateDC op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbConnectToDcs op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    @Override
    public AntidoteResponse handle(AntidotePB.ApbGetConnectionDescriptor op) {
        try {
            ApbCoder.encodeRequest(op, this.socket.getOutputStream());
            return ApbCoder.decodeResponse(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AntidoteSocketException(e);
        }
    }

    public static class AntidoteSocketException
    extends AntidoteException {
        public AntidoteSocketException(IOException cause) {
            super(cause);
        }
    }
}

