/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.ResponseDecoder;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import eu.antidotedb.client.ValueCoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;

public class SetKey<T>
extends Key<List<T>> {
    private final ValueCoder<T> format;

    SetKey(AntidotePB.CRDT_type type, ByteString key, ValueCoder<T> format) {
        super(type, key);
        this.format = format;
    }

    @CheckReturnValue
    public final UpdateOpDefaultImpl add(T value) {
        return this.addAll((Iterable<? extends T>)Collections.singletonList(value));
    }

    @SafeVarargs
    @CheckReturnValue
    public final UpdateOpDefaultImpl addAll(T ... values) {
        return this.addAll((Iterable<? extends T>)Arrays.asList(values));
    }

    @CheckReturnValue
    public UpdateOpDefaultImpl addAll(Iterable<? extends T> values) {
        AntidotePB.ApbSetUpdate.Builder op = AntidotePB.ApbSetUpdate.newBuilder();
        for (T value : values) {
            op.addAdds(this.format.encode(value));
        }
        op.setOptype(AntidotePB.ApbSetUpdate.SetOpType.ADD);
        AntidotePB.ApbUpdateOperation.Builder update = AntidotePB.ApbUpdateOperation.newBuilder();
        update.setSetop(op);
        return new UpdateOpDefaultImpl(this, update);
    }

    @CheckReturnValue
    public final UpdateOpDefaultImpl remove(T value) {
        return this.removeAll((Iterable<? extends T>)Collections.singletonList(value));
    }

    @SafeVarargs
    @CheckReturnValue
    public final UpdateOpDefaultImpl removeAll(T ... values) {
        return this.removeAll((Iterable<? extends T>)Arrays.asList(values));
    }

    @CheckReturnValue
    public UpdateOpDefaultImpl removeAll(Iterable<? extends T> values) {
        AntidotePB.ApbSetUpdate.Builder op = AntidotePB.ApbSetUpdate.newBuilder();
        for (T value : values) {
            op.addRems(this.format.encode(value));
        }
        op.setOptype(AntidotePB.ApbSetUpdate.SetOpType.REMOVE);
        AntidotePB.ApbUpdateOperation.Builder update = AntidotePB.ApbUpdateOperation.newBuilder();
        update.setSetop(op);
        return new UpdateOpDefaultImpl(this, update);
    }

    @Override
    List<T> readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
        return ResponseDecoder.set(this.format).readResponseToValue(resp);
    }
}

