/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.MapKey;
import eu.antidotedb.client.ValueCoder;
import java.util.Collections;
import java.util.List;

public abstract class ResponseDecoder<Value> {
    abstract Value readResponseToValue(AntidotePB.ApbReadObjectResp var1);

    public static ResponseDecoder<Integer> counter() {
        return new ResponseDecoder<Integer>(){

            @Override
            Integer readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return 0;
                }
                if (resp.getCounter() == null) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return resp.getCounter().getValue();
            }
        };
    }

    public static <T> ResponseDecoder<T> register(final ValueCoder<T> format) {
        return new ResponseDecoder<T>(){

            @Override
            T readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return null;
                }
                if (!resp.hasReg()) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return format.decode(resp.getReg().getValue());
            }
        };
    }

    public static ResponseDecoder<String> register() {
        return ResponseDecoder.register(ValueCoder.utf8String);
    }

    public static <T> ResponseDecoder<List<T>> multiValueRegister(final ValueCoder<T> format) {
        return new ResponseDecoder<List<T>>(){

            @Override
            List<T> readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return Collections.emptyList();
                }
                if (!resp.hasMvreg()) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return format.decodeList(resp.getMvreg().getValuesList());
            }
        };
    }

    public static ResponseDecoder<List<String>> multiValueRegister() {
        return ResponseDecoder.multiValueRegister(ValueCoder.utf8String);
    }

    public static <T> ResponseDecoder<List<T>> set(final ValueCoder<T> format) {
        return new ResponseDecoder<List<T>>(){

            @Override
            List<T> readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return Collections.emptyList();
                }
                if (!resp.hasSet()) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return format.decodeList(resp.getSet().getValueList());
            }
        };
    }

    public static ResponseDecoder<List<String>> set() {
        return ResponseDecoder.set(ValueCoder.utf8String);
    }

    public static <K> ResponseDecoder<MapKey.MapReadResult> map() {
        return new ResponseDecoder<MapKey.MapReadResult>(){

            @Override
            MapKey.MapReadResult readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return new MapKey.MapReadResult(Collections.emptyList());
                }
                if (!resp.hasMap()) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return new MapKey.MapReadResult(resp.getMap().getEntriesList());
            }
        };
    }

    public static ResponseDecoder<Boolean> flag() {
        return new ResponseDecoder<Boolean>(){

            @Override
            Boolean readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
                if (resp == null) {
                    return false;
                }
                if (!resp.hasFlag()) {
                    throw new AntidoteException("Invalid response " + resp);
                }
                return resp.getFlag().getValue();
            }
        };
    }
}

