/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.ResponseDecoder;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import eu.antidotedb.client.ValueCoder;
import javax.annotation.CheckReturnValue;

public class RegisterKey<T>
extends Key<T> {
    private final ValueCoder<T> format;

    RegisterKey(AntidotePB.CRDT_type type, ByteString key, ValueCoder<T> format) {
        super(type, key);
        this.format = format;
    }

    @CheckReturnValue
    public UpdateOpDefaultImpl assign(T value) {
        return RegisterKey.buildRegisterUpdate(this, this.format.encode(value));
    }

    static UpdateOpDefaultImpl buildRegisterUpdate(Key<?> key, ByteString value) {
        AntidotePB.ApbRegUpdate.Builder regUpdateInstruction = AntidotePB.ApbRegUpdate.newBuilder();
        regUpdateInstruction.setValue(value);
        AntidotePB.ApbUpdateOperation.Builder updateOperation = AntidotePB.ApbUpdateOperation.newBuilder();
        updateOperation.setRegop(regUpdateInstruction);
        return new UpdateOpDefaultImpl(key, updateOperation);
    }

    @Override
    T readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
        return ResponseDecoder.register(this.format).readResponseToValue(resp);
    }
}

