/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.ConnectionPool;
import eu.antidotedb.client.transformer.TransformerFactory;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PoolManager {
    private static final int CHECK_INTERVAL = 3;
    public static final int DEFAULT_INITIAL_POOL_SIZE = 1;
    public static final int DEFAULT_MAX_POOL_SIZE = 50;
    private List<ConnectionPool> pools = new CopyOnWriteArrayList<ConnectionPool>();
    private final List<TransformerFactory> transformerFactories;

    public PoolManager(List<TransformerFactory> transformerFactories) {
        this.transformerFactories = transformerFactories;
        this.unhealthyHostRecovery();
    }

    public void addHost(int maxPoolSize, int initialPoolSize, InetSocketAddress h) {
        this.pools.add(new ConnectionPool(maxPoolSize, initialPoolSize, h, this.transformerFactories));
    }

    public void addHost(InetSocketAddress h) {
        this.addHost(50, 1, h);
    }

    private void unhealthyHostRecovery() {
        Thread t = new Thread(() -> {
            try {
                while (true) {
                    for (ConnectionPool p : this.pools) {
                        if (!p.checkHealth(p)) continue;
                        p.setHealthy(true);
                    }
                    TimeUnit.MINUTES.sleep(3L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public Connection getConnection() {
        int selectedIndex = 0;
        if (this.pools.size() > 0) {
            for (int i = 0; i < this.pools.size(); ++i) {
                selectedIndex = (int)(Math.random() * (double)this.pools.size());
                ConnectionPool p2 = this.pools.get(selectedIndex);
                if (!p2.isHealthy()) continue;
                try {
                    Connection c = p2.getConnection();
                    if (c == null) continue;
                    return c;
                }
                catch (InterruptedException e) {
                    throw new AntidoteException(e);
                }
            }
        }
        throw new AntidoteException("Cannot open connection to any host. (Configured hosts: " + this.pools.stream().map(p -> p.getInetSocketAddress().toString()).collect(Collectors.joining(", ")) + ")");
    }
}

