/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteClient;
import eu.antidotedb.client.BatchReadResultImpl;
import eu.antidotedb.client.CommitInfo;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.TransactionWithReads;
import eu.antidotedb.client.messages.AntidoteRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NoTransaction
extends TransactionWithReads {
    private final AntidoteClient client;
    private final CommitInfo timestamp;
    private CommitInfo lastCommitTimestamp;

    public NoTransaction(AntidoteClient client) {
        this(client, null);
    }

    public NoTransaction(AntidoteClient client, CommitInfo timestamp) {
        this.client = client;
        this.timestamp = timestamp;
    }

    @Override
    void performUpdate(AntidotePB.ApbUpdateOp.Builder updateInstruction) {
        this.performUpdates(Collections.singletonList(updateInstruction));
    }

    @Override
    void performUpdates(Collection<AntidotePB.ApbUpdateOp.Builder> updateInstructions) {
        AntidotePB.ApbStaticUpdateObjects.Builder updateMessage = AntidotePB.ApbStaticUpdateObjects.newBuilder();
        AntidotePB.ApbStartTransaction.Builder startTransaction = AntidotePB.ApbStartTransaction.newBuilder();
        if (this.timestamp != null) {
            startTransaction.setTimestamp(this.timestamp.getCommitTime());
        }
        updateMessage.setTransaction(startTransaction);
        for (AntidotePB.ApbUpdateOp.Builder updateInstruction : updateInstructions) {
            updateMessage.addUpdates(updateInstruction);
        }
        AntidotePB.ApbCommitResp commitResponse = this.client.sendMessageArbitraryConnection(this, AntidoteRequest.of(updateMessage.build()));
        this.lastCommitTimestamp = this.client.completeTransaction(commitResponse);
    }

    @Override
    AntidotePB.ApbReadObjectsResp readHelper(ByteString bucket, ByteString key, AntidotePB.CRDT_type type) {
        AntidotePB.ApbStaticReadObjects.Builder readMessage = AntidotePB.ApbStaticReadObjects.newBuilder();
        AntidotePB.ApbBoundObject.Builder obj = AntidotePB.ApbBoundObject.newBuilder().setBucket(bucket).setType(type).setKey(key);
        readMessage.addObjects(obj);
        AntidotePB.ApbStartTransaction.Builder startTransaction = AntidotePB.ApbStartTransaction.newBuilder();
        readMessage.setTransaction(startTransaction);
        AntidotePB.ApbStaticReadObjectsResp resp = this.client.sendMessageArbitraryConnection(this, AntidoteRequest.of(readMessage.build()));
        this.client.completeTransaction(resp.getCommittime());
        return resp.getObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void batchReadHelper(List<BatchReadResultImpl> requests) {
        AntidotePB.ApbStaticReadObjects.Builder readObject = AntidotePB.ApbStaticReadObjects.newBuilder();
        for (BatchReadResultImpl request : requests) {
            readObject.addObjects(request.getObject());
        }
        readObject.setTransaction(AntidotePB.ApbStartTransaction.newBuilder().build());
        AntidotePB.ApbStaticReadObjects readObjectsMessage = readObject.build();
        Connection connection = this.client.getPoolManager().getConnection();
        try {
            this.onGetConnection(connection);
            AntidoteRequest.MsgStaticReadObjects request = AntidoteRequest.of(readObjectsMessage);
            AntidotePB.ApbStaticReadObjectsResp readResponse = this.client.sendMessage(request, connection);
            int i = 0;
            for (AntidotePB.ApbReadObjectResp resp : readResponse.getObjects().getObjectsList()) {
                requests.get(i).setResult(resp);
                ++i;
            }
        }
        finally {
            this.onReleaseConnection(connection);
            connection.close();
        }
    }

    public CommitInfo getLastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }
}

