/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.RegisterKey;
import eu.antidotedb.client.ResponseDecoder;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import eu.antidotedb.client.ValueCoder;
import java.util.List;
import javax.annotation.CheckReturnValue;

public class MergeRegisterKey<V>
extends Key<MergeResult<V>> {
    private ValueCoder<V> format;
    private ValueMerger<V> merger;

    MergeRegisterKey(ByteString key, ValueCoder<V> format, ValueMerger<V> merger) {
        super(AntidotePB.CRDT_type.MVREG, key);
        this.format = format;
        this.merger = merger;
    }

    @Override
    MergeResult<V> readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
        List<V> concValues = ResponseDecoder.multiValueRegister(this.format).readResponseToValue(resp);
        return new MergeResult<V>(concValues.size() > 1, this.merger.merge(concValues));
    }

    @CheckReturnValue
    public UpdateOpDefaultImpl assign(V value) {
        return RegisterKey.buildRegisterUpdate(this, this.format.encode(value));
    }

    public static interface ValueMerger<V> {
        public V merge(List<V> var1);
    }

    public static class MergeResult<V> {
        private boolean merged;
        private V value;

        public MergeResult(boolean merged, V value) {
            this.merged = merged;
            this.value = value;
        }

        public boolean isMerged() {
            return this.merged;
        }

        public V getValue() {
            return this.value;
        }
    }
}

