/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.ResponseDecoder;
import eu.antidotedb.client.UpdateOp;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;

public class MapKey
extends Key<MapReadResult> {
    MapKey(AntidotePB.CRDT_type type, ByteString key) {
        super(type, key);
    }

    @Override
    MapReadResult readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
        return ResponseDecoder.map().readResponseToValue(resp);
    }

    @CheckReturnValue
    public UpdateOp update(UpdateOp ... keyUpdates) {
        return this.update(Arrays.asList(keyUpdates));
    }

    @CheckReturnValue
    public UpdateOp update(Iterable<UpdateOp> keyUpdates) {
        AntidotePB.ApbUpdateOperation.Builder operation = AntidotePB.ApbUpdateOperation.newBuilder();
        AntidotePB.ApbMapUpdate.Builder mapUpdate = AntidotePB.ApbMapUpdate.newBuilder();
        for (UpdateOp keyUpdate : keyUpdates) {
            mapUpdate.addUpdates(keyUpdate.toApbNestedUpdate());
        }
        operation.setMapop(mapUpdate);
        return new UpdateOpDefaultImpl(this, operation);
    }

    @CheckReturnValue
    public UpdateOp removeKey(Key<?> key) {
        return this.removeKeys(Collections.singletonList(key));
    }

    @CheckReturnValue
    public UpdateOp removeKeys(Key<?> ... keys) {
        return this.removeKeys(Arrays.asList(keys));
    }

    @CheckReturnValue
    public UpdateOp removeKeys(Iterable<? extends Key<?>> keys) {
        AntidotePB.ApbUpdateOperation.Builder operation = AntidotePB.ApbUpdateOperation.newBuilder();
        AntidotePB.ApbMapUpdate.Builder mapUpdate = AntidotePB.ApbMapUpdate.newBuilder();
        for (Key<?> key : keys) {
            mapUpdate.addRemovedKeys(key.toApbMapKey());
        }
        operation.setMapop(mapUpdate);
        return new UpdateOpDefaultImpl(this, operation);
    }

    @CheckReturnValue
    public MapUpdateOpBuilder operation() {
        return new MapUpdateOpBuilder();
    }

    public static class MapReadResult
    extends AbstractMap<Key<?>, Object> {
        private Map<Key<?>, AntidotePB.ApbReadObjectResp> responses = new LinkedHashMap();

        MapReadResult(List<AntidotePB.ApbMapEntry> entriesList) {
            for (AntidotePB.ApbMapEntry entry : entriesList) {
                AntidotePB.ApbMapKey key = entry.getKey();
                this.responses.put(Key.fromApbMapKey(key), entry.getValue());
            }
        }

        @Override
        @Deprecated
        public Object get(Object key) {
            if (key instanceof Key) {
                return this.get((Key)key);
            }
            throw new IllegalArgumentException("Invalid type for key " + key);
        }

        public <V> V get(Key<V> key) {
            AntidotePB.ApbReadObjectResp resp = this.responses.get(key);
            return key.readResponseToValue(resp);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.responses.containsKey(key);
        }

        @Override
        public int size() {
            return this.responses.size();
        }

        @Override
        public Set<Key<?>> keySet() {
            return Collections.unmodifiableSet(this.responses.keySet());
        }

        @Override
        public Set<Map.Entry<Key<?>, Object>> entrySet() {
            return new AbstractSet<Map.Entry<Key<?>, Object>>(){

                @Override
                public Iterator<Map.Entry<Key<?>, Object>> iterator() {
                    final Iterator it = responses.entrySet().iterator();
                    return new Iterator<Map.Entry<Key<?>, Object>>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<Key<?>, Object> next() {
                            final Map.Entry entry = (Map.Entry)it.next();
                            return new Map.Entry<Key<?>, Object>(){

                                @Override
                                public Key<?> getKey() {
                                    return (Key)entry.getKey();
                                }

                                @Override
                                public Object getValue() {
                                    return ((Key)entry.getKey()).readResponseToValue((AntidotePB.ApbReadObjectResp)entry.getValue());
                                }

                                @Override
                                public Object setValue(Object value) {
                                    throw new UnsupportedOperationException("The MapReadResult cannot be changed.");
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return responses.size();
                }
            };
        }

        public <V> Map<String, V> asJavaMap(ResponseDecoder<V> responseDecoder) {
            return this.asJavaMap(key -> key.getKey().toStringUtf8(), responseDecoder);
        }

        public <K, V> Map<K, V> asJavaMap(Function<Key<?>, K> keyCoder, ResponseDecoder<V> responseDecoder) {
            LinkedHashMap<K, V> res = new LinkedHashMap<K, V>();
            for (Map.Entry<Key<?>, AntidotePB.ApbReadObjectResp> entry : this.responses.entrySet()) {
                res.put(keyCoder.apply(entry.getKey()), responseDecoder.readResponseToValue(entry.getValue()));
            }
            return res;
        }
    }

    public class MapUpdateOpBuilder
    extends UpdateOp {
        Set<Key<?>> changedKeys;
        AntidotePB.ApbMapUpdate.Builder op;

        MapUpdateOpBuilder() {
            super(MapKey.this);
            this.changedKeys = new HashSet();
            this.op = AntidotePB.ApbMapUpdate.newBuilder();
        }

        @Override
        AntidotePB.ApbUpdateOperation.Builder getApbUpdate() {
            AntidotePB.ApbUpdateOperation.Builder updateOperation = AntidotePB.ApbUpdateOperation.newBuilder();
            updateOperation.setMapop(this.op);
            return updateOperation;
        }

        public MapUpdateOpBuilder update(UpdateOp ... keyUpdates) {
            return this.update(Arrays.asList(keyUpdates));
        }

        public MapUpdateOpBuilder update(Iterable<UpdateOp> keyUpdates) {
            for (UpdateOp keyUpdate : keyUpdates) {
                if (!this.changedKeys.add(keyUpdate.getKey())) {
                    throw new AntidoteException("Key " + keyUpdate.getKey() + " is already changed in this map update.");
                }
                this.op.addUpdates(keyUpdate.toApbNestedUpdate());
            }
            return this;
        }

        public MapUpdateOpBuilder removeKey(Key<?> key) {
            return this.removeKeys(Collections.singletonList(key));
        }

        public MapUpdateOpBuilder removeKeys(Key<?> ... keys) {
            return this.removeKeys(Arrays.asList(keys));
        }

        public MapUpdateOpBuilder removeKeys(Iterable<? extends Key<?>> keys) {
            for (Key<?> key : keys) {
                if (!this.changedKeys.add(key)) {
                    throw new AntidoteException("Key " + key + " is already changed in this map update.");
                }
                this.op.addRemovedKeys(key.toApbMapKey());
            }
            return this;
        }
    }
}

