/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.RegisterKey;
import eu.antidotedb.client.ResponseDecoder;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import eu.antidotedb.client.ValueCoder;
import java.util.List;
import javax.annotation.CheckReturnValue;

public class MVRegisterKey<T>
extends Key<List<T>> {
    private final ValueCoder<T> format;

    MVRegisterKey(ByteString key, ValueCoder<T> format) {
        super(AntidotePB.CRDT_type.MVREG, key);
        this.format = format;
    }

    @CheckReturnValue
    public UpdateOpDefaultImpl assign(T value) {
        return RegisterKey.buildRegisterUpdate(this, this.format.encode(value));
    }

    @Override
    List<T> readResponseToValue(AntidotePB.ApbReadObjectResp resp) {
        return ResponseDecoder.multiValueRegister(this.format).readResponseToValue(resp);
    }
}

