/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.CounterKey;
import eu.antidotedb.client.FlagKey;
import eu.antidotedb.client.MVRegisterKey;
import eu.antidotedb.client.MapKey;
import eu.antidotedb.client.MergeRegisterKey;
import eu.antidotedb.client.RegisterKey;
import eu.antidotedb.client.SetKey;
import eu.antidotedb.client.UpdateOp;
import eu.antidotedb.client.UpdateOpDefaultImpl;
import eu.antidotedb.client.ValueCoder;
import java.util.Objects;
import javax.annotation.CheckReturnValue;

public abstract class Key<Value> {
    private final AntidotePB.CRDT_type type;
    private final ByteString key;

    Key(AntidotePB.CRDT_type type, ByteString key) {
        this.type = type;
        this.key = key;
    }

    public AntidotePB.CRDT_type getType() {
        return this.type;
    }

    public ByteString getKey() {
        return this.key;
    }

    abstract Value readResponseToValue(AntidotePB.ApbReadObjectResp var1);

    public String toString() {
        return (Object)((Object)this.type) + "_" + this.key.toStringUtf8();
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Key)) {
            return false;
        }
        Key k = (Key)obj;
        return k.type.equals((Object)this.type) && k.key.equals((Object)this.key);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key});
    }

    public static CounterKey counter(ByteString key) {
        return new CounterKey(AntidotePB.CRDT_type.COUNTER, key);
    }

    public static CounterKey counter(String key) {
        return new CounterKey(AntidotePB.CRDT_type.COUNTER, ByteString.copyFromUtf8((String)key));
    }

    public static CounterKey fatCounter(ByteString key) {
        return new CounterKey(AntidotePB.CRDT_type.FATCOUNTER, key);
    }

    public static CounterKey fatCounter(String key) {
        return Key.fatCounter(ByteString.copyFromUtf8((String)key));
    }

    public static <T> RegisterKey<T> register(ByteString key, ValueCoder<T> format) {
        return new RegisterKey<T>(AntidotePB.CRDT_type.LWWREG, key, format);
    }

    public static RegisterKey<String> register(ByteString key) {
        return Key.register(key, ValueCoder.utf8String);
    }

    public static <T> RegisterKey<T> register(String key, ValueCoder<T> format) {
        return Key.register(ByteString.copyFromUtf8((String)key), format);
    }

    public static RegisterKey<String> register(String key) {
        return Key.register(key, ValueCoder.utf8String);
    }

    public static <T> MVRegisterKey<T> multiValueRegister(ByteString key, ValueCoder<T> format) {
        return new MVRegisterKey<T>(key, format);
    }

    public static MVRegisterKey<String> multiValueRegister(ByteString key) {
        return Key.multiValueRegister(key, ValueCoder.utf8String);
    }

    public static <T> MVRegisterKey<T> multiValueRegister(String key, ValueCoder<T> format) {
        return Key.multiValueRegister(ByteString.copyFromUtf8((String)key), format);
    }

    public static MVRegisterKey<String> multiValueRegister(String key) {
        return Key.multiValueRegister(key, ValueCoder.utf8String);
    }

    public static <T> SetKey<T> set(ByteString key, ValueCoder<T> format) {
        return new SetKey<T>(AntidotePB.CRDT_type.ORSET, key, format);
    }

    public static SetKey<String> set(ByteString key) {
        return Key.set(key, ValueCoder.utf8String);
    }

    public static <T> SetKey<T> set(String key, ValueCoder<T> format) {
        return Key.set(ByteString.copyFromUtf8((String)key), format);
    }

    public static SetKey<String> set(String key) {
        return Key.set(key, ValueCoder.utf8String);
    }

    public static <T> SetKey<T> set_removeWins(ByteString key, ValueCoder<T> format) {
        return new SetKey<T>(AntidotePB.CRDT_type.RWSET, key, format);
    }

    public static SetKey<String> set_removeWins(ByteString key) {
        return Key.set_removeWins(key, ValueCoder.utf8String);
    }

    public static <T> SetKey<T> set_removeWins(String key, ValueCoder<T> format) {
        return Key.set_removeWins(ByteString.copyFromUtf8((String)key), format);
    }

    public static SetKey<String> set_removeWins(String key) {
        return Key.set_removeWins(key, ValueCoder.utf8String);
    }

    public static MapKey map_rr(ByteString key) {
        return new MapKey(AntidotePB.CRDT_type.RRMAP, key);
    }

    public static MapKey map_rr(String key) {
        return Key.map_rr(ByteString.copyFromUtf8((String)key));
    }

    public static MapKey map_g(ByteString key) {
        return new MapKey(AntidotePB.CRDT_type.GMAP, key);
    }

    public static MapKey map_g(String key) {
        return Key.map_g(ByteString.copyFromUtf8((String)key));
    }

    public static FlagKey flag_ew(ByteString key) {
        return new FlagKey(AntidotePB.CRDT_type.FLAG_EW, key);
    }

    public static FlagKey flag_ew(String key) {
        return Key.flag_ew(ByteString.copyFromUtf8((String)key));
    }

    public static FlagKey flag_dw(ByteString key) {
        return new FlagKey(AntidotePB.CRDT_type.FLAG_DW, key);
    }

    public static FlagKey flag_dw(String key) {
        return Key.flag_dw(ByteString.copyFromUtf8((String)key));
    }

    public static <V> MergeRegisterKey<V> mergeRegister(ByteString key, ValueCoder<V> format, MergeRegisterKey.ValueMerger<V> merger) {
        return new MergeRegisterKey<V>(key, format, merger);
    }

    public static <V> MergeRegisterKey<V> mergeRegister(String key, ValueCoder<V> format, MergeRegisterKey.ValueMerger<V> merger) {
        return Key.mergeRegister(ByteString.copyFromUtf8((String)key), format, merger);
    }

    AntidotePB.ApbMapKey.Builder toApbMapKey() {
        AntidotePB.ApbMapKey.Builder builder = AntidotePB.ApbMapKey.newBuilder();
        builder.setType(this.type);
        builder.setKey(this.key);
        return builder;
    }

    static Key<?> fromApbMapKey(AntidotePB.ApbMapKey key) {
        ByteString k = key.getKey();
        AntidotePB.CRDT_type type = key.getType();
        return Key.create(type, k);
    }

    public static Key<?> create(AntidotePB.CRDT_type type, ByteString k) {
        switch (type) {
            case COUNTER: {
                return Key.counter(k);
            }
            case ORSET: {
                return Key.set(k);
            }
            case LWWREG: {
                return Key.register(k);
            }
            case MVREG: {
                return Key.multiValueRegister(k);
            }
            case GMAP: {
                return Key.map_g(k);
            }
            case RWSET: {
                return Key.set_removeWins(k);
            }
            case RRMAP: {
                return Key.map_rr(k);
            }
            case FATCOUNTER: {
                return Key.fatCounter(k);
            }
            case FLAG_EW: {
                return Key.flag_ew(k);
            }
            case FLAG_DW: {
                return Key.flag_dw(k);
            }
        }
        throw new RuntimeException("CRDT not yet supported: " + (Object)((Object)type));
    }

    @CheckReturnValue
    public UpdateOp reset() {
        AntidotePB.ApbCrdtReset.Builder op = AntidotePB.ApbCrdtReset.newBuilder();
        AntidotePB.ApbUpdateOperation.Builder updateOperation = AntidotePB.ApbUpdateOperation.newBuilder();
        updateOperation.setResetop(op);
        return new UpdateOpDefaultImpl(this, updateOperation);
    }
}

