/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteClient;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.BatchReadResultImpl;
import eu.antidotedb.client.CommitInfo;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.TransactionWithReads;
import eu.antidotedb.client.messages.AntidoteRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InteractiveTransaction
extends TransactionWithReads
implements AutoCloseable {
    protected Connection connection;
    protected final AntidoteClient antidoteClient;
    protected TransactionStatus transactionStatus;
    protected ByteString descriptor;

    public InteractiveTransaction(AntidoteClient antidoteClient) {
        this(antidoteClient, null);
    }

    public InteractiveTransaction(AntidoteClient antidoteClient, CommitInfo timestamp) {
        this.antidoteClient = antidoteClient;
        this.connection = antidoteClient.getPoolManager().getConnection();
        this.onGetConnection(this.connection);
        this.startTransaction(timestamp);
        this.transactionStatus = TransactionStatus.STARTED;
    }

    private void startTransaction(CommitInfo timestamp) {
        AntidotePB.ApbTxnProperties.Builder transactionProperties = AntidotePB.ApbTxnProperties.newBuilder();
        AntidotePB.ApbStartTransaction.Builder readwriteTransaction = AntidotePB.ApbStartTransaction.newBuilder();
        readwriteTransaction.setProperties(transactionProperties);
        if (timestamp != null) {
            readwriteTransaction.setTimestamp(timestamp.getCommitTime());
        }
        AntidotePB.ApbStartTransaction startTransactionMessage = readwriteTransaction.build();
        AntidotePB.ApbStartTransactionResp transactionResponse = this.getClient().sendMessage(AntidoteRequest.of(startTransactionMessage), this.connection);
        this.descriptor = transactionResponse.getTransactionDescriptor();
    }

    protected AntidoteClient getClient() {
        return this.antidoteClient;
    }

    public CommitInfo commitTransaction() {
        if (this.descriptor == null) {
            throw new AntidoteException("You need to start the transaction before committing it");
        }
        if (this.transactionStatus != TransactionStatus.STARTED) {
            throw new AntidoteException("You need to start the transaction before committing it");
        }
        AntidotePB.ApbCommitTransaction.Builder commitTransaction = AntidotePB.ApbCommitTransaction.newBuilder();
        commitTransaction.setTransactionDescriptor(this.descriptor);
        AntidotePB.ApbCommitTransaction commitTransactionMessage = commitTransaction.build();
        this.descriptor = null;
        AntidotePB.ApbCommitResp commitResponse = this.getClient().sendMessage(AntidoteRequest.of(commitTransactionMessage), this.connection);
        CommitInfo res = this.antidoteClient.completeTransaction(commitResponse);
        this.transactionStatus = TransactionStatus.COMMITTED;
        this.close();
        return res;
    }

    public void abortTransaction() {
        if (this.transactionStatus != TransactionStatus.STARTED) {
            throw new AntidoteException("Cannot abort transaction in state " + (Object)((Object)this.transactionStatus));
        }
        AntidotePB.ApbAbortTransaction.Builder abortTransaction = AntidotePB.ApbAbortTransaction.newBuilder();
        abortTransaction.setTransactionDescriptor(this.descriptor);
        AntidotePB.ApbAbortTransaction abortTransactionMessage = abortTransaction.build();
        this.getClient().sendMessage(AntidoteRequest.of(abortTransactionMessage), this.connection);
        this.transactionStatus = TransactionStatus.ABORTED;
        this.close();
    }

    protected void updateHelper(AntidotePB.ApbUpdateOperation.Builder operation, String name, String bucket, AntidotePB.CRDT_type type) {
        if (this.transactionStatus != TransactionStatus.STARTED) {
            throw new AntidoteException("You need to start the transaction first");
        }
        AntidotePB.ApbBoundObject.Builder object = AntidotePB.ApbBoundObject.newBuilder();
        object.setKey(ByteString.copyFromUtf8((String)name));
        object.setType(type);
        object.setBucket(ByteString.copyFromUtf8((String)bucket));
        AntidotePB.ApbUpdateOp.Builder updateInstruction = AntidotePB.ApbUpdateOp.newBuilder();
        updateInstruction.setBoundobject(object);
        updateInstruction.setOperation(operation);
        this.performUpdate(updateInstruction);
    }

    @Override
    void performUpdate(AntidotePB.ApbUpdateOp.Builder updateInstruction) {
        this.performUpdates(Collections.singletonList(updateInstruction));
    }

    @Override
    void performUpdates(Collection<AntidotePB.ApbUpdateOp.Builder> updateInstructions) {
        if (this.getDescriptor() == null) {
            throw new AntidoteException("You need to start the transaction first");
        }
        AntidotePB.ApbUpdateObjects.Builder updateMessage = AntidotePB.ApbUpdateObjects.newBuilder();
        updateMessage.setTransactionDescriptor(this.getDescriptor());
        for (AntidotePB.ApbUpdateOp.Builder updateInstruction : updateInstructions) {
            updateMessage.addUpdates(updateInstruction);
        }
        AntidotePB.ApbUpdateObjects updateMessageObject = updateMessage.build();
        AntidotePB.ApbOperationResp resp = this.getClient().sendMessage(AntidoteRequest.of(updateMessageObject), this.connection);
        if (!resp.getSuccess()) {
            throw new AntidoteException("Could not perform update (error code: " + resp.getErrorcode() + ")");
        }
    }

    @Override
    protected AntidotePB.ApbReadObjectsResp readHelper(ByteString bucket, ByteString key, AntidotePB.CRDT_type type) {
        if (this.getDescriptor() == null) {
            throw new AntidoteException("You need to start the transaction first");
        }
        if (this.transactionStatus != TransactionStatus.STARTED) {
            throw new AntidoteException("You need to start the transaction first");
        }
        AntidotePB.ApbBoundObject.Builder object = AntidotePB.ApbBoundObject.newBuilder();
        object.setKey(key);
        object.setType(type);
        object.setBucket(bucket);
        AntidotePB.ApbReadObjects.Builder readObject = AntidotePB.ApbReadObjects.newBuilder();
        readObject.addBoundobjects(object);
        readObject.setTransactionDescriptor(this.getDescriptor());
        AntidotePB.ApbReadObjects readObjectsMessage = readObject.build();
        return this.antidoteClient.sendMessage(AntidoteRequest.of(readObjectsMessage), this.connection);
    }

    @Override
    void batchReadHelper(List<BatchReadResultImpl> readRequests) {
        AntidotePB.ApbReadObjects.Builder readObject = AntidotePB.ApbReadObjects.newBuilder();
        for (BatchReadResultImpl batchReadResultImpl : readRequests) {
            readObject.addBoundobjects(batchReadResultImpl.getObject());
        }
        readObject.setTransactionDescriptor(this.descriptor);
        AntidotePB.ApbReadObjects readObjectsMessage = readObject.build();
        AntidoteRequest.MsgReadObjects msgReadObjects = AntidoteRequest.of(readObjectsMessage);
        AntidotePB.ApbReadObjectsResp readResponse = this.antidoteClient.sendMessage(msgReadObjects, this.connection);
        int i = 0;
        for (AntidotePB.ApbReadObjectResp resp : readResponse.getObjectsList()) {
            readRequests.get(i).setResult(resp);
            ++i;
        }
    }

    protected ByteString getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void close() {
        if (this.transactionStatus == TransactionStatus.STARTED) {
            this.abortTransaction();
        }
        if (this.transactionStatus != TransactionStatus.CLOSED) {
            this.transactionStatus = TransactionStatus.CLOSED;
            this.onReleaseConnection(this.connection);
            this.connection.close();
        }
    }

    protected static enum TransactionStatus {
        STARTED,
        COMMITTED,
        ABORTED,
        CLOSED;

    }
}

