/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.transformer.TransformerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionPool {
    private static final Logger logger = Logger.getLogger(ConnectionPool.class.getCanonicalName());
    private static final int DEFAULT_TIMEOUT = 0;
    private static final long GET_CONNECTION_WAIT_MS = 20L;
    private static final int MAX_FAILURE = 3;
    private final BlockingQueue<Connection> pool;
    private final List<Connection> connections = new CopyOnWriteArrayList<Connection>();
    private final int maxPoolSize;
    private final int initialPoolSize;
    private InetSocketAddress inetAddr;
    private volatile boolean healthy;
    private AtomicInteger failures = new AtomicInteger();
    private List<TransformerFactory> transformerFactories;

    public ConnectionPool(int maxPoolSize, int initialPoolSize, InetSocketAddress inetAddr, List<TransformerFactory> transformerFactories) {
        this.transformerFactories = transformerFactories;
        if (initialPoolSize > maxPoolSize || initialPoolSize < 1 || maxPoolSize < 1) {
            throw new IllegalArgumentException("Invalid pool size parameters");
        }
        this.maxPoolSize = maxPoolSize;
        this.initialPoolSize = initialPoolSize;
        this.inetAddr = inetAddr;
        this.pool = new ArrayBlockingQueue<Connection>(maxPoolSize);
        this.healthy = true;
        for (int i = 0; i < initialPoolSize && this.isHealthy() && this.getCurrentPoolSize() < maxPoolSize; ++i) {
            if (this.openAndPoolConnection() || this.failures.incrementAndGet() < 3) continue;
            this.setHealthy(false);
        }
        if (this.pool.size() != initialPoolSize) {
            logger.log(Level.WARNING, "Initial sized pool creation failed. InitializedPoolSize={0}, initialPoolSize={1}", new Object[]{this.pool.size(), initialPoolSize});
        }
    }

    public boolean checkHealth(ConnectionPool p) {
        try {
            Connection s = p.getConnection();
            s.getSocket().setSoTimeout(0);
            p.surrenderConnection(s);
            p.setHealthy(true);
            return true;
        }
        catch (IOException e) {
            p.setHealthy(false);
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private boolean openAndPoolConnection() {
        try {
            Connection c = this.openConnection();
            this.pool.offer(c);
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error opening connection to " + this.inetAddr.toString(), e);
            return false;
        }
    }

    private Connection openConnection() throws IOException {
        Socket s = new Socket();
        s.setSoTimeout(0);
        s.connect(this.inetAddr, 0);
        Connection c = new Connection(this, s, this.transformerFactories);
        this.connections.add(c);
        return c;
    }

    public Connection getConnection() throws InterruptedException {
        Connection connection = this.pool.poll(20L, TimeUnit.MILLISECONDS);
        if (connection != null) {
            return connection;
        }
        if (this.getCurrentPoolSize() < this.getMaxPoolSize()) {
            try {
                return this.openConnection();
            }
            catch (IOException e) {
                throw new AntidoteException("Could not open connection to " + this.inetAddr.toString(), e);
            }
        }
        throw new AntidoteException("Could not get connection to " + this.inetAddr.toString() + " (too many connections)");
    }

    public void surrenderConnection(Connection s) {
        try {
            this.pool.add(s);
        }
        catch (IllegalStateException e) {
            s.discard();
            this.connections.remove(s);
        }
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetAddr;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public int getCurrentPoolSize() {
        return this.connections.size();
    }

    public int getActiveConnections() {
        return this.connections.size() - this.pool.size();
    }
}

