/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.client.ConnectionPool;
import eu.antidotedb.client.SocketSender;
import eu.antidotedb.client.transformer.Transformer;
import eu.antidotedb.client.transformer.TransformerFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public class Connection
implements AutoCloseable {
    private final ConnectionPool pool;
    private final Socket socket;
    private Transformer transformer;

    public Connection(ConnectionPool p, Socket s, List<TransformerFactory> transformerFactories) {
        this.pool = p;
        this.socket = s;
        this.transformer = new SocketSender(s);
        for (TransformerFactory transformerFactory : transformerFactories) {
            this.transformer = transformerFactory.newTransformer(this.transformer, this);
        }
    }

    public void returnConnection() {
        this.pool.surrenderConnection(this);
    }

    public void setunHealthyConnection() {
        this.pool.setHealthy(false);
    }

    @Override
    public void close() {
        this.returnConnection();
    }

    public Transformer transformer() {
        return this.transformer;
    }

    void discard() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Socket getSocket() {
        return this.socket;
    }
}

