/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.AntidoteTransaction;
import eu.antidotedb.client.BatchRead;
import eu.antidotedb.client.BatchReadResult;
import eu.antidotedb.client.BatchReadResultImpl;
import eu.antidotedb.client.Key;
import eu.antidotedb.client.TransactionWithReads;
import eu.antidotedb.client.UpdateOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;

public class Bucket {
    private final ByteString name;

    Bucket(ByteString name) {
        this.name = name;
    }

    public static Bucket bucket(String name) {
        return new Bucket(ByteString.copyFromUtf8((String)name));
    }

    public static Bucket bucket(ByteString name) {
        return new Bucket(name);
    }

    public ByteString getName() {
        return this.name;
    }

    public String toString() {
        return "Bucket-" + this.name;
    }

    @CheckReturnValue
    public <T> T read(TransactionWithReads tx, Key<T> key) {
        AntidotePB.ApbReadObjectsResp resp = tx.readHelper(this.name, key.getKey(), key.getType());
        if (resp.getSuccess()) {
            return key.readResponseToValue(resp.getObjects(0));
        }
        throw new AntidoteException("Error when reading " + key + " (error code " + resp.getErrorcode() + ")");
    }

    @SafeVarargs
    @CheckReturnValue
    public final <T> List<T> readAll(TransactionWithReads tx, Key<? extends T> ... keys) {
        return this.readAll(tx, Arrays.asList(keys));
    }

    @CheckReturnValue
    public <T> List<T> readAll(TransactionWithReads tx, Collection<? extends Key<? extends T>> keys) {
        BatchRead batchRead = new BatchRead();
        ArrayList<BatchReadResult<T>> results = new ArrayList<BatchReadResult<T>>(keys.size());
        for (Key<T> key : keys) {
            BatchReadResult<T> read = this.read(batchRead, key);
            results.add(read);
        }
        batchRead.commit(tx);
        return results.stream().map(BatchReadResult::get).collect(Collectors.toList());
    }

    @CheckReturnValue
    public <T> BatchReadResult<T> read(BatchRead tx, Key<T> key) {
        BatchReadResultImpl resp = tx.readHelper(this.name, key.getKey(), key.getType());
        return resp.map(key::readResponseToValue);
    }

    public void update(AntidoteTransaction tx, UpdateOp update) {
        this.updates(tx, Collections.singleton(update));
    }

    public void updates(AntidoteTransaction tx, UpdateOp ... updates) {
        this.updates(tx, Arrays.asList(updates));
    }

    public void updates(AntidoteTransaction tx, Collection<? extends UpdateOp> updates) {
        tx.performUpdates(updates.stream().map(upd -> upd.getApbUpdate(this.name)).collect(Collectors.toList()));
    }
}

