/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.BatchRead;
import eu.antidotedb.client.BatchReadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class BatchReadResultImpl
implements BatchReadResult<AntidotePB.ApbReadObjectResp> {
    private final BatchRead batchRead;
    private final AntidotePB.ApbBoundObject.Builder object;
    private AntidotePB.ApbReadObjectResp result = null;
    private final List<Consumer<AntidotePB.ApbReadObjectResp>> listeners = new ArrayList<Consumer<AntidotePB.ApbReadObjectResp>>();

    public BatchReadResultImpl(BatchRead batchRead, AntidotePB.ApbBoundObject.Builder object) {
        this.batchRead = batchRead;
        this.object = object;
    }

    @Override
    public AntidotePB.ApbReadObjectResp get() {
        if (this.result == null) {
            throw new IllegalStateException("Must commit batch-read before reading result.");
        }
        return this.result;
    }

    @Override
    public void whenReady(Consumer<AntidotePB.ApbReadObjectResp> f) {
        if (this.result == null) {
            this.listeners.add(f);
        } else {
            f.accept(this.result);
        }
    }

    public void setResult(AntidotePB.ApbReadObjectResp result) {
        this.result = result;
        for (Consumer<AntidotePB.ApbReadObjectResp> callback : this.listeners) {
            callback.accept(result);
        }
    }

    public AntidotePB.ApbBoundObject.Builder getObject() {
        return this.object;
    }
}

