/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import java.util.function.Consumer;
import java.util.function.Function;

public interface BatchReadResult<T> {
    public T get();

    public void whenReady(Consumer<T> var1);

    default public <S> BatchReadResult<S> map(final Function<T, S> f) {
        final BatchReadResult parent = this;
        return new BatchReadResult<S>(){
            S cache = null;

            @Override
            public S get() {
                if (this.cache == null) {
                    Object t = parent.get();
                    this.cache = f.apply(t);
                }
                return this.cache;
            }

            @Override
            public void whenReady(Consumer<S> callback) {
                if (this.cache == null) {
                    parent.whenReady((T t) -> callback.accept(this.get()));
                } else {
                    callback.accept(this.cache);
                }
            }
        };
    }
}

