/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.GeneratedMessageV3;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.messages.AntidoteRequest;
import eu.antidotedb.client.messages.AntidoteResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ApbCoder {
    public static AntidoteRequest<?> decodeRequest(InputStream stream) throws IOException {
        byte[] sizeRaw = new byte[4];
        ApbCoder.readFully(stream, sizeRaw);
        ByteBuffer buffer = ByteBuffer.wrap(sizeRaw);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int size = buffer.getInt();
        int msgCode = stream.read();
        if (msgCode == -1) {
            throw new IOException("End of input while message code expected");
        }
        byte[] data = new byte[size - 1];
        ApbCoder.readFully(stream, data);
        switch (msgCode) {
            case 116: {
                AntidotePB.ApbReadObjects apbReadObjects = AntidotePB.ApbReadObjects.parseFrom(data);
                return AntidoteRequest.of(apbReadObjects);
            }
            case 118: {
                AntidotePB.ApbUpdateObjects apbUpdateObjects = AntidotePB.ApbUpdateObjects.parseFrom(data);
                return AntidoteRequest.of(apbUpdateObjects);
            }
            case 119: {
                AntidotePB.ApbStartTransaction apbStartTransaction = AntidotePB.ApbStartTransaction.parseFrom(data);
                return AntidoteRequest.of(apbStartTransaction);
            }
            case 120: {
                AntidotePB.ApbAbortTransaction apbAbortTransaction = AntidotePB.ApbAbortTransaction.parseFrom(data);
                return AntidoteRequest.of(apbAbortTransaction);
            }
            case 121: {
                AntidotePB.ApbCommitTransaction apbCommitTransaction = AntidotePB.ApbCommitTransaction.parseFrom(data);
                return AntidoteRequest.of(apbCommitTransaction);
            }
            case 122: {
                AntidotePB.ApbStaticUpdateObjects apbStaticUpdateObjects = AntidotePB.ApbStaticUpdateObjects.parseFrom(data);
                return AntidoteRequest.of(apbStaticUpdateObjects);
            }
            case 123: {
                AntidotePB.ApbStaticReadObjects apbStaticReadObjects = AntidotePB.ApbStaticReadObjects.parseFrom(data);
                return AntidoteRequest.of(apbStaticReadObjects);
            }
            case 129: {
                AntidotePB.ApbCreateDC apbCreateDC = AntidotePB.ApbCreateDC.parseFrom(data);
                return AntidoteRequest.of(apbCreateDC);
            }
            case 130: {
                AntidotePB.ApbConnectToDcs apbConnectToDcs = AntidotePB.ApbConnectToDcs.parseFrom(data);
                return AntidoteRequest.of(apbConnectToDcs);
            }
            case 131: {
                AntidotePB.ApbGetConnectionDescriptor apbGetConnectionDescriptor = AntidotePB.ApbGetConnectionDescriptor.parseFrom(data);
                return AntidoteRequest.of(apbGetConnectionDescriptor);
            }
        }
        throw new RuntimeException("Unexpected request message code: " + msgCode);
    }

    public static AntidoteResponse decodeResponse(InputStream stream) throws IOException {
        byte[] sizeRaw = new byte[4];
        ApbCoder.readFully(stream, sizeRaw);
        ByteBuffer buffer = ByteBuffer.wrap(sizeRaw);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int size = buffer.getInt();
        int msgCode = stream.read();
        if (msgCode == -1) {
            throw new IOException("End of input while message code expected");
        }
        byte[] data = new byte[size - 1];
        ApbCoder.readFully(stream, data);
        switch (msgCode) {
            case 0: {
                AntidotePB.ApbErrorResp apbErrorResp = AntidotePB.ApbErrorResp.parseFrom(data);
                return AntidoteResponse.of(apbErrorResp);
            }
            case 111: {
                AntidotePB.ApbOperationResp apbOperationResp = AntidotePB.ApbOperationResp.parseFrom(data);
                return AntidoteResponse.of(apbOperationResp);
            }
            case 124: {
                AntidotePB.ApbStartTransactionResp apbStartTransactionResp = AntidotePB.ApbStartTransactionResp.parseFrom(data);
                return AntidoteResponse.of(apbStartTransactionResp);
            }
            case 126: {
                AntidotePB.ApbReadObjectsResp apbReadObjectsResp = AntidotePB.ApbReadObjectsResp.parseFrom(data);
                return AntidoteResponse.of(apbReadObjectsResp);
            }
            case 127: {
                AntidotePB.ApbCommitResp apbCommitResp = AntidotePB.ApbCommitResp.parseFrom(data);
                return AntidoteResponse.of(apbCommitResp);
            }
            case 128: {
                AntidotePB.ApbStaticReadObjectsResp apbStaticReadObjectsResp = AntidotePB.ApbStaticReadObjectsResp.parseFrom(data);
                return AntidoteResponse.of(apbStaticReadObjectsResp);
            }
            case 132: {
                AntidotePB.ApbGetConnectionDescriptorResponse apbGetConnectionDescriptorResponse = AntidotePB.ApbGetConnectionDescriptorResponse.parseFrom(data);
                return AntidoteResponse.of(apbGetConnectionDescriptorResponse);
            }
        }
        throw new RuntimeException("Unexpected message code: " + msgCode);
    }

    private static void readFully(InputStream stream, byte[] data) throws IOException {
        int bytesRead;
        for (int offset = 0; offset < data.length; offset += bytesRead) {
            bytesRead = stream.read(data, offset, data.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("End of input while data expected");
        }
    }

    public static void encodeRequest(AntidotePB.ApbReadObjects op, OutputStream stream) {
        ApbCoder.encode(116, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbUpdateObjects op, OutputStream stream) {
        ApbCoder.encode(118, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbStartTransaction op, OutputStream stream) {
        ApbCoder.encode(119, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbAbortTransaction op, OutputStream stream) {
        ApbCoder.encode(120, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbCommitTransaction op, OutputStream stream) {
        ApbCoder.encode(121, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbStaticReadObjects op, OutputStream stream) {
        ApbCoder.encode(123, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbStaticUpdateObjects op, OutputStream stream) {
        ApbCoder.encode(122, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbCreateDC op, OutputStream stream) {
        ApbCoder.encode(129, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbConnectToDcs op, OutputStream stream) {
        ApbCoder.encode(130, op, stream);
    }

    public static void encodeRequest(AntidotePB.ApbGetConnectionDescriptor op, OutputStream stream) {
        ApbCoder.encode(131, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbOperationResp op, OutputStream stream) {
        ApbCoder.encode(111, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbStartTransactionResp op, OutputStream stream) {
        ApbCoder.encode(124, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbReadObjectsResp op, OutputStream stream) {
        ApbCoder.encode(126, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbCommitResp op, OutputStream stream) {
        ApbCoder.encode(127, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbStaticReadObjectsResp op, OutputStream stream) {
        ApbCoder.encode(128, op, stream);
    }

    public static void encodeResponse(AntidotePB.ApbGetConnectionDescriptorResponse op, OutputStream stream) {
        ApbCoder.encode(132, op, stream);
    }

    private static void encode(int msgCode, GeneratedMessageV3 msg, OutputStream stream) {
        int serializedSize = msg.getSerializedSize();
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(serializedSize + 1);
        buffer.put((byte)msgCode);
        BufferedOutputStream os = new BufferedOutputStream(stream);
        try {
            ((OutputStream)os).write(buffer.array());
            msg.writeTo((OutputStream)os);
            ((OutputStream)os).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void encodeRequest(AntidoteRequest<?> request, final OutputStream stream) {
        request.accept(new AntidoteRequest.Handler<Void>(){

            @Override
            public Void handle(AntidotePB.ApbReadObjects op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbUpdateObjects op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbStartTransaction op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbAbortTransaction op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbCommitTransaction op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbStaticReadObjects op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbStaticUpdateObjects op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbCreateDC op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbConnectToDcs op) {
                ApbCoder.encodeRequest(op, stream);
                return null;
            }
        });
    }

    public static void encodeResponse(AntidoteResponse response, final OutputStream stream) {
        response.accept(new AntidoteResponse.Handler<Void>(){

            @Override
            public Void handle(AntidotePB.ApbOperationResp op) {
                ApbCoder.encodeResponse(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbStartTransactionResp op) {
                ApbCoder.encodeResponse(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbReadObjectsResp op) {
                ApbCoder.encodeResponse(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbCommitResp op) {
                ApbCoder.encodeResponse(op, stream);
                return null;
            }

            @Override
            public Void handle(AntidotePB.ApbStaticReadObjectsResp op) {
                ApbCoder.encodeResponse(op, stream);
                return null;
            }
        });
    }
}

