/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteClient;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.AntidoteTransaction;
import eu.antidotedb.client.CommitInfo;
import eu.antidotedb.client.InteractiveTransaction;
import eu.antidotedb.client.messages.AntidoteRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AntidoteStaticTransaction
extends AntidoteTransaction {
    private final AntidoteClient client;
    private final CommitInfo timestamp;
    private InteractiveTransaction.TransactionStatus transactionStatus = InteractiveTransaction.TransactionStatus.STARTED;
    private List<AntidotePB.ApbUpdateOp.Builder> transactionUpdateList = new ArrayList<AntidotePB.ApbUpdateOp.Builder>();

    AntidoteStaticTransaction(AntidoteClient antidoteClient) {
        this(antidoteClient, null);
    }

    AntidoteStaticTransaction(AntidoteClient antidoteClient, CommitInfo timestamp) {
        this.client = antidoteClient;
        this.timestamp = timestamp;
    }

    public CommitInfo commitTransaction() {
        if (this.transactionStatus != InteractiveTransaction.TransactionStatus.STARTED) {
            throw new AntidoteException("Transaction already closed");
        }
        AntidotePB.ApbCommitResp commitResponse = this.client.sendMessageArbitraryConnection(this, AntidoteRequest.of(this.createUpdateStaticObject()));
        CommitInfo res = this.client.completeTransaction(commitResponse);
        this.transactionStatus = InteractiveTransaction.TransactionStatus.COMMITTED;
        return res;
    }

    protected AntidotePB.ApbStaticUpdateObjects createUpdateStaticObject() {
        AntidotePB.ApbStaticUpdateObjects.Builder updateMessage = AntidotePB.ApbStaticUpdateObjects.newBuilder();
        AntidotePB.ApbStartTransaction.Builder startTransaction = AntidotePB.ApbStartTransaction.newBuilder();
        if (this.timestamp != null) {
            startTransaction.setTimestamp(this.timestamp.getCommitTime());
        }
        updateMessage.setTransaction(startTransaction);
        for (AntidotePB.ApbUpdateOp.Builder updateInstruction : this.transactionUpdateList) {
            updateMessage.addUpdates(updateInstruction);
        }
        return updateMessage.build();
    }

    @Override
    void performUpdate(AntidotePB.ApbUpdateOp.Builder updateInstruction) {
        this.transactionUpdateList.add(updateInstruction);
    }

    @Override
    void performUpdates(Collection<AntidotePB.ApbUpdateOp.Builder> updateInstructions) {
        this.transactionUpdateList.addAll(updateInstructions);
    }

    List<AntidotePB.ApbUpdateOp.Builder> getTransactionUpdateList() {
        return this.transactionUpdateList;
    }
}

