/*
 * Decompiled with CFR 0.152.
 */
package eu.antidotedb.client;

import com.google.protobuf.ByteString;
import eu.antidotedb.antidotepb.AntidotePB;
import eu.antidotedb.client.AntidoteException;
import eu.antidotedb.client.AntidoteStaticTransaction;
import eu.antidotedb.client.AntidoteTransaction;
import eu.antidotedb.client.BatchRead;
import eu.antidotedb.client.CommitInfo;
import eu.antidotedb.client.Connection;
import eu.antidotedb.client.InteractiveTransaction;
import eu.antidotedb.client.NoTransaction;
import eu.antidotedb.client.PoolManager;
import eu.antidotedb.client.SocketSender;
import eu.antidotedb.client.messages.AntidoteRequest;
import eu.antidotedb.client.messages.AntidoteResponse;
import eu.antidotedb.client.transformer.TransformerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AntidoteClient {
    private PoolManager poolManager;

    public AntidoteClient(InetSocketAddress ... inetAddrs) {
        this(Collections.emptyList(), inetAddrs);
    }

    public AntidoteClient(List<InetSocketAddress> inetAddrs) {
        this(Collections.emptyList(), inetAddrs);
    }

    public AntidoteClient(List<TransformerFactory> transformerFactories, InetSocketAddress ... inetAddrs) {
        this(transformerFactories, Arrays.asList(inetAddrs));
    }

    public AntidoteClient(List<TransformerFactory> transformerFactories, List<InetSocketAddress> inetAddrs) {
        this.init(transformerFactories, inetAddrs);
    }

    protected void init(List<TransformerFactory> transformerFactories, List<InetSocketAddress> inetAddrs) {
        this.poolManager = new PoolManager(transformerFactories);
        for (InetSocketAddress host : inetAddrs) {
            this.poolManager.addHost(host);
        }
    }

    public AntidoteClient(PoolManager poolManager) {
        this.poolManager = poolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R sendMessageArbitraryConnection(AntidoteTransaction tx, AntidoteRequest<R> requestMessage) {
        Connection connection = this.getPoolManager().getConnection();
        try {
            tx.onGetConnection(connection);
            R r = this.sendMessage(requestMessage, connection);
            return r;
        }
        finally {
            tx.onReleaseConnection(connection);
            connection.close();
        }
    }

    <R> R sendMessage(AntidoteRequest<R> requestMessage, Connection connection) {
        AntidoteResponse.Handler<R> responseExtractor = requestMessage.readResponseExtractor();
        AntidoteResponse response = requestMessage.accept(connection.transformer());
        if (responseExtractor == null) {
            return null;
        }
        if (response == null) {
            throw new AntidoteException("Missing response for " + requestMessage);
        }
        return response.accept(responseExtractor);
    }

    public InteractiveTransaction startTransaction() {
        return new InteractiveTransaction(this, null);
    }

    public InteractiveTransaction startTransaction(CommitInfo timestamp) {
        return new InteractiveTransaction(this, timestamp);
    }

    public AntidoteStaticTransaction createStaticTransaction() {
        return new AntidoteStaticTransaction(this, null);
    }

    public AntidoteStaticTransaction createStaticTransaction(CommitInfo timestamp) {
        return new AntidoteStaticTransaction(this, timestamp);
    }

    public BatchRead newBatchRead() {
        return new BatchRead();
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    CommitInfo completeTransaction(AntidotePB.ApbCommitResp commitResponse) {
        if (commitResponse.getSuccess()) {
            return new CommitInfo(commitResponse.getCommitTime());
        }
        throw new AntidoteException("Failed to commit transaction (Error code: " + commitResponse.getErrorcode() + ")");
    }

    public NoTransaction noTransaction() {
        return new NoTransaction(this, null);
    }

    public NoTransaction noTransaction(CommitInfo timestamp) {
        return new NoTransaction(this, timestamp);
    }

    public static boolean createDC(InetSocketAddress managerNode, List<String> nodeNames) throws IOException {
        try (Socket s = new Socket();){
            s.connect(managerNode);
            AntidotePB.ApbCreateDC createDCMsg = AntidotePB.ApbCreateDC.newBuilder().addAllNodes(nodeNames).build();
            SocketSender socketSender = new SocketSender(s);
            AntidotePB.ApbOperationResp createDCResp = socketSender.handle(createDCMsg).accept(new AntidoteResponse.MsgOperationResp.Extractor());
            boolean bl = createDCResp.getSuccess();
            return bl;
        }
    }

    public static ByteString getConnectionDescriptor(InetSocketAddress managerNode) throws IOException {
        try (Socket s = new Socket();){
            s.connect(managerNode);
            AntidotePB.ApbGetConnectionDescriptor apbGetConnectionDescriptor = AntidotePB.ApbGetConnectionDescriptor.newBuilder().build();
            SocketSender socketSender = new SocketSender(s);
            AntidotePB.ApbGetConnectionDescriptorResponse connectionDescriptor = socketSender.handle(apbGetConnectionDescriptor).accept(new AntidoteResponse.MsgGetConnectionDescriptorResponse.Extractor());
            if (connectionDescriptor.getSuccess()) {
                ByteString byteString = connectionDescriptor.getConDesc();
                return byteString;
            }
            throw new IOException("Error getting connection descriptor of node: Error code " + connectionDescriptor.getErrorcode());
        }
    }

    public static boolean connectToDCs(InetSocketAddress managerNode, List<ByteString> descriptors) throws IOException {
        try (Socket s = new Socket();){
            s.connect(managerNode);
            AntidotePB.ApbConnectToDcs apbConnectToDcs = AntidotePB.ApbConnectToDcs.newBuilder().addAllDescriptors(descriptors).build();
            SocketSender socketSender = new SocketSender(s);
            AntidotePB.ApbOperationResp createDCResp = socketSender.handle(apbConnectToDcs).accept(new AntidoteResponse.MsgOperationResp.Extractor());
            boolean bl = createDCResp.getSuccess();
            return bl;
        }
    }
}

