/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop.scan;

import eu.agilejava.snoop.annotation.EnableSnoopClient;
import eu.agilejava.snoop.scan.SnoopExtensionHelper;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;

public class SnoopScannerExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private String applicationName;
    private boolean snoopEnabled;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        LOGGER.config("Scanning for Snoop clients");
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        SnoopExtensionHelper.setApplicationName(this.applicationName);
        SnoopExtensionHelper.setSnoopEnabled(this.snoopEnabled);
        LOGGER.config("Finished scanning for Snoop clients");
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={EnableSnoopClient.class}) ProcessAnnotatedType<T> pat) {
        LOGGER.config(() -> "Found @EnableSnoopClient annotated class: " + pat.getAnnotatedType().getJavaClass().getName());
        this.snoopEnabled = true;
        this.applicationName = ((EnableSnoopClient)pat.getAnnotatedType().getAnnotation(EnableSnoopClient.class)).name();
        LOGGER.config(() -> "Snoop Application name is: " + this.applicationName);
    }
}

