/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop.scan;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import eu.agilejava.snoop.SnoopConfigurationException;
import eu.agilejava.snoop.client.SnoopConfig;
import eu.agilejava.snoop.scan.SnoopExtensionHelper;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ScheduleExpression;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
@Singleton
@Startup
public class SnoopClient {
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private static final String DEFAULT_SERVICE_HOST = "localhost:8080/snoop-service/";
    private static final String REGISTER_ENDPOINT = "snoop";
    private static final String STATUS_ENDPOINT = "snoopstatus/";
    private String serviceUrl;
    private final SnoopConfig applicationConfig = new SnoopConfig();
    @Resource
    private TimerService timerService;

    @PostConstruct
    private void init() {
        LOGGER.config("Checking if snoop is enabled");
        if (SnoopExtensionHelper.isSnoopEnabled()) {
            try {
                this.readConfiguration();
                LOGGER.config(() -> "Registering " + this.applicationConfig.getApplicationName());
                this.register(this.applicationConfig.getApplicationName());
            }
            catch (SnoopConfigurationException e) {
                LOGGER.severe(() -> "Snoop is enabled but not configured properly: " + e.getMessage());
            }
        } else {
            LOGGER.config("Snoop is not enabled. Use @EnableSnoopClient!");
        }
    }

    public void register(String clientId) {
        this.sendMessage(REGISTER_ENDPOINT, this.applicationConfig.toJSON());
        ScheduleExpression schedule = new ScheduleExpression();
        schedule.second("*/10").minute("*").hour("*").start(Calendar.getInstance().getTime());
        TimerConfig config = new TimerConfig();
        config.setPersistent(false);
        Timer timer = this.timerService.createCalendarTimer(schedule, config);
        LOGGER.config(() -> timer.getSchedule().toString());
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        LOGGER.config(() -> "Message: " + message);
        this.sendMessage(STATUS_ENDPOINT + this.applicationConfig.getApplicationName(), this.applicationConfig.toJSON());
    }

    @Timeout
    public void health(Timer timer) {
        LOGGER.config(() -> "health update: " + Calendar.getInstance().getTime());
        LOGGER.config(() -> "Next: " + timer.getNextTimeout());
        this.sendMessage(STATUS_ENDPOINT + this.applicationConfig.getApplicationName(), this.applicationConfig.toJSON());
    }

    private String sendMessage(String endpoint, String msg) {
        LOGGER.config(() -> "Sending message: " + msg);
        String returnValue = "-1";
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            String uri = this.serviceUrl + endpoint;
            Session session = container.connectToServer((Object)this, URI.create(uri));
            session.getBasicRemote().sendText(msg != null ? msg : "");
            returnValue = session.getId();
        }
        catch (IOException | DeploymentException ex) {
            LOGGER.warning(ex.getMessage());
        }
        return returnValue;
    }

    @PreDestroy
    private void deregister() {
        LOGGER.config(() -> "Deregistering " + this.applicationConfig.getApplicationName());
        this.sendMessage(STATUS_ENDPOINT + this.applicationConfig.getApplicationName(), null);
    }

    private void readConfiguration() throws SnoopConfigurationException {
        Map snoopConfig = Collections.EMPTY_MAP;
        try {
            Yaml yaml = new Yaml();
            Map props = (Map)yaml.load(this.getClass().getResourceAsStream("/application.yml"));
            snoopConfig = (Map)props.get(REGISTER_ENDPOINT);
        }
        catch (YAMLException e) {
            LOGGER.config(() -> "No configuration file. Using env properties.");
        }
        this.applicationConfig.setApplicationName(SnoopExtensionHelper.getApplicationName());
        String host = this.readProperty("host", snoopConfig);
        String port = this.readProperty("port", snoopConfig);
        this.applicationConfig.setApplicationHome(host + ":" + port);
        this.applicationConfig.setApplicationServiceRoot(this.readProperty("serviceRoot", snoopConfig));
        LOGGER.config(() -> "application config: " + this.applicationConfig.toJSON());
        this.serviceUrl = "ws://" + this.readProperty("serviceHost", snoopConfig);
    }

    private String readProperty(String key, Map<String, Object> snoopConfig) {
        String property = Optional.ofNullable(System.getenv(this.applicationConfig.getApplicationName() + "." + key)).orElseGet(() -> {
            String p = Optional.ofNullable(snoopConfig.get(key)).orElseThrow(() -> new SnoopConfigurationException(key + " must be configured either in application.yml or as env parameter")).toString();
            return p;
        });
        return property;
    }
}

