/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop;

import eu.agilejava.snoop.SnoopConfig;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.Singleton;

@Singleton
public class SnoopClientRegistry {
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private final Map<String, Long> clients = new ConcurrentHashMap();
    private final Map<String, SnoopConfig> clientConfigurations = new ConcurrentHashMap();

    public void register(SnoopConfig client) {
        Calendar now = Calendar.getInstance();
        this.clients.put(client.getApplicationName(), now.getTimeInMillis());
        this.clientConfigurations.put(client.getApplicationName(), client);
        LOGGER.config(() -> "Client: " + client.getApplicationName() + " registered up at " + now.getTime());
    }

    public void deRegister(String clientId) {
        this.clients.remove(clientId);
        this.clientConfigurations.remove(clientId);
        LOGGER.config(() -> "Client: " + clientId + " deregistered at " + Calendar.getInstance().getTime());
    }

    public Set<String> getClients() {
        return this.clients.keySet().stream().filter(c -> (Long)this.clients.get(c) > System.currentTimeMillis() - 60000L).collect(Collectors.toSet());
    }

    public Collection<SnoopConfig> getServiceConfigs() {
        return this.clientConfigurations.values();
    }

    public Optional<SnoopConfig> getClientConfig(String clientId) {
        if (this.getClients().contains(clientId)) {
            return Optional.ofNullable(this.clientConfigurations.get(clientId));
        }
        return Optional.empty();
    }
}

