/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop.client;

import eu.agilejava.snoop.client.SnoopConfig;
import eu.agilejava.snoop.client.SnoopServiceUnavailableException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class SnoopServiceClient {
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private static final String DEFAULT_BASE_URI = "http://localhost:8080/snoop-service/";
    private final String applicationName;
    private final String serviceUrl;

    private SnoopServiceClient(Builder builder) {
        this.applicationName = builder.applicationName;
        this.serviceUrl = builder.serviceUrl;
        LOGGER.info(() -> "client created for " + this.applicationName);
    }

    public WebTarget getServiceRoot() throws SnoopServiceUnavailableException {
        SnoopConfig snoopConfig = this.getConfigFromSnoop();
        LOGGER.fine(() -> "looking up service for " + this.applicationName);
        return ClientBuilder.newClient().target(snoopConfig.getServiceHome()).path(snoopConfig.getServiceRoot());
    }

    public Optional<Response> simpleGet(String resourcePath) {
        Optional<Response> returnValue = Optional.empty();
        try {
            returnValue = Optional.of(this.getServiceRoot().path(resourcePath).request().get());
        }
        catch (SnoopServiceUnavailableException e) {
            LOGGER.warning(() -> "Service unavailable for " + this.applicationName);
        }
        return returnValue;
    }

    public Optional<Response> simpleDelete(String resourcePath) {
        Optional<Response> returnValue = Optional.empty();
        try {
            returnValue = Optional.of(this.getServiceRoot().path(resourcePath).request().delete());
        }
        catch (SnoopServiceUnavailableException e) {
            LOGGER.warning(() -> "Service unavailable for " + this.applicationName);
        }
        return returnValue;
    }

    public Optional<Response> simplePut(String resourcePath, Object resource) {
        Optional<Response> returnValue = Optional.empty();
        try {
            returnValue = Optional.of(this.getServiceRoot().path(resourcePath).request().put(Entity.entity((Object)resource, (String)"application/json")));
        }
        catch (SnoopServiceUnavailableException e) {
            LOGGER.warning(() -> "Service unavailable for " + this.applicationName);
        }
        return returnValue;
    }

    public Optional<Response> simplePost(String resourcePath, Object resource) {
        Optional<Response> returnValue = Optional.empty();
        try {
            returnValue = Optional.of(this.getServiceRoot().path(resourcePath).request().post(Entity.entity((Object)resource, (String)"application/json")));
        }
        catch (SnoopServiceUnavailableException e) {
            LOGGER.warning(() -> "Service unavailable for " + this.applicationName);
        }
        return returnValue;
    }

    private SnoopConfig getConfigFromSnoop() throws SnoopServiceUnavailableException {
        try {
            Response response = ClientBuilder.newClient().target(this.serviceUrl).path("api").path("services").path(this.applicationName).request(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                return (SnoopConfig)response.readEntity(SnoopConfig.class);
            }
            throw new SnoopServiceUnavailableException("Response from \"" + this.serviceUrl + "\"=" + response.getStatus());
        }
        catch (ProcessingException e) {
            throw new SnoopServiceUnavailableException(e);
        }
    }

    static final class Builder {
        private final String applicationName;
        private String serviceUrl = "http://localhost:8080/snoop-service/";

        Builder(String applicationName) {
            this.applicationName = applicationName;
        }

        Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        SnoopServiceClient build() {
            return new SnoopServiceClient(this);
        }
    }
}

