/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop.client;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import eu.agilejava.snoop.SnoopConfigurationException;
import eu.agilejava.snoop.annotation.Snoop;
import eu.agilejava.snoop.client.SnoopServiceClient;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class SnoopProducer {
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private Map<String, Object> snoopConfig = Collections.EMPTY_MAP;

    @Snoop
    @Produces
    @Dependent
    public SnoopServiceClient lookup(InjectionPoint ip) {
        String applicationName = ((Snoop)ip.getAnnotated().getAnnotation(Snoop.class)).serviceName();
        LOGGER.config(() -> "producing " + applicationName);
        String serviceUrl = "http://" + this.readProperty("snoopService", this.snoopConfig);
        LOGGER.config(() -> "Service URL: " + serviceUrl);
        return new SnoopServiceClient.Builder(applicationName).serviceUrl(serviceUrl).build();
    }

    private String readProperty(String key, Map<String, Object> snoopConfig) {
        String property = Optional.ofNullable(System.getProperty(key)).orElseGet(() -> {
            String envProp = Optional.ofNullable(System.getenv(key)).orElseGet(() -> {
                String confProp = Optional.ofNullable(snoopConfig.get(key)).orElseThrow(() -> new SnoopConfigurationException(key + " must be configured either in application.yml or as env or system property")).toString();
                return confProp;
            });
            return envProp;
        });
        return property;
    }

    @PostConstruct
    private void init() {
        try {
            Yaml yaml = new Yaml();
            Map props = (Map)yaml.load(this.getClass().getResourceAsStream("/snoop.yml"));
            this.snoopConfig = (Map)props.get("snoop");
        }
        catch (YAMLException e) {
            LOGGER.config(() -> "No configuration file. Using env properties.");
        }
    }
}

