/*
 * Decompiled with CFR 0.152.
 */
package eu.agilejava.snoop.client;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import eu.agilejava.snoop.SnoopConfigurationException;
import eu.agilejava.snoop.annotation.Snoop;
import eu.agilejava.snoop.client.SnoopDiscoveryClient;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class SnoopProducer {
    private static final String DEFAULT_BASE_HOST = "localhost:8080/snoop-service/";
    private static final Logger LOGGER = Logger.getLogger("eu.agilejava.snoop");
    private String serviceUrl;

    @Snoop
    @Produces
    @Dependent
    public SnoopDiscoveryClient lookup(InjectionPoint ip) {
        String applicationName = ((Snoop)ip.getAnnotated().getAnnotation(Snoop.class)).applicationName();
        LOGGER.config(() -> "producing " + applicationName);
        return new SnoopDiscoveryClient.Builder(applicationName).serviceUrl(this.serviceUrl).build();
    }

    @PostConstruct
    private void init() {
        Map snoopConfig = Collections.EMPTY_MAP;
        try {
            Yaml yaml = new Yaml();
            Map props = (Map)yaml.load(this.getClass().getResourceAsStream("/application.yml"));
            snoopConfig = (Map)props.get("snoop");
        }
        catch (YAMLException e) {
            LOGGER.config(() -> "No configuration file. Using env properties.");
        }
        this.serviceUrl = "http://" + this.readProperty("serviceHost", snoopConfig);
        LOGGER.config(() -> "Service URL: " + this.serviceUrl);
    }

    private String readProperty(String key, Map<String, Object> snoopConfig) {
        String property = Optional.ofNullable(System.getProperty(key)).orElseGet(() -> {
            String envProp = Optional.ofNullable(System.getenv(key)).orElseGet(() -> {
                String confProp = Optional.ofNullable(snoopConfig.get(key)).orElseThrow(() -> new SnoopConfigurationException(key + " must be configured either in application.yml or as env or system property")).toString();
                return confProp;
            });
            return envProp;
        });
        return property;
    }
}

