/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkbenchContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected Viewer viewer;
    static /* synthetic */ Class class$0;

    public void dispose() {
        if (this.viewer != null) {
            Object obj = this.viewer.getInput();
            if (obj instanceof IWorkspace) {
                IWorkspace workspace = (IWorkspace)obj;
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            } else if (obj instanceof IContainer) {
                IWorkspace workspace = ((IContainer)obj).getWorkspace();
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public Object[] getChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getChildren(element);
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    protected void processDelta(IResourceDelta delta) {
        int i;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0) {
            ((StructuredViewer)this.viewer).update((Object)resource, null);
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3]);
            ++i3;
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            Object[] affected = new Object[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (this.viewer instanceof AbstractTreeViewer) {
                ((AbstractTreeViewer)this.viewer).remove(affected);
            } else {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            Object[] affected = new Object[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (this.viewer instanceof AbstractTreeViewer) {
                ((AbstractTreeViewer)this.viewer).add((Object)resource, affected);
            } else {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    WorkbenchContentProvider.this.processDelta(delta);
                }
            });
        }
    }
}

