/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.ICategory;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;

public class ViewRegistry
implements IViewRegistry {
    private List views = new ArrayList();
    private List categories = new ArrayList();
    private Category miscCategory;

    public void add(ICategory desc) {
        if (this.findCategory(desc.getId()) == null) {
            this.categories.add(desc);
        }
    }

    public void add(IViewDescriptor desc) {
        this.views.add(desc);
    }

    public IViewDescriptor find(String id) {
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public ICategory findCategory(String id) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category cat = (Category)iterator.next();
            if (!id.equals(cat.getRootPath())) continue;
            return cat;
        }
        return null;
    }

    public ICategory[] getCategories() {
        int nSize = this.categories.size();
        ICategory[] retArray = new ICategory[nSize];
        this.categories.toArray(retArray);
        return retArray;
    }

    public int getCategoryCount() {
        return this.categories.size();
    }

    public ICategory getMiscCategory() {
        return this.miscCategory;
    }

    public int getViewCount() {
        return this.views.size();
    }

    public IViewDescriptor[] getViews() {
        int nSize = this.views.size();
        IViewDescriptor[] retArray = new IViewDescriptor[nSize];
        this.views.toArray(retArray);
        return retArray;
    }

    public void mapViewsToCategories() {
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            Category cat = null;
            String[] catPath = desc.getCategoryPath();
            if (catPath != null) {
                String rootCat = catPath[0];
                cat = (Category)this.findCategory(rootCat);
            }
            if (cat != null) {
                cat.addElement(desc);
                continue;
            }
            if (this.miscCategory == null) {
                this.miscCategory = new Category();
                this.categories.add(this.miscCategory);
            }
            this.miscCategory.addElement(desc);
        }
    }
}

