/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.model.WorkbenchAdapter;
import org.eclipse.ui.internal.registry.ICategory;

public class Category
extends WorkbenchAdapter
implements ICategory {
    private static final String ATT_ID = "id";
    private static final String ATT_PARENT = "parentCategory";
    private static final String ATT_NAME = "name";
    private String id;
    private String name;
    private String[] parentPath;
    private String unparsedPath;
    private ArrayList elements;
    static /* synthetic */ Class class$0;

    public Category() {
        this.id = "org.eclipse.ui.internal.otherCategory";
        this.name = ICategory.MISC_NAME;
    }

    public Category(String id, String label) {
        this.id = id;
        this.name = label;
    }

    public Category(IConfigurationElement configElement) throws WorkbenchException {
        this.id = configElement.getAttribute(ATT_ID);
        this.name = configElement.getAttribute(ATT_NAME);
        this.unparsedPath = configElement.getAttribute(ATT_PARENT);
        if (this.id == null || this.name == null) {
            throw new WorkbenchException("Invalid category: " + this.id);
        }
    }

    public void addElement(Object element) {
        if (this.elements == null) {
            this.elements = new ArrayList(5);
        }
        this.elements.add(element);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return this.getElements().toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public String getLabel(Object o) {
        return this.getLabel();
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.name;
    }

    public String[] getParentPath() {
        if (this.unparsedPath != null) {
            StringTokenizer stok = new StringTokenizer(this.unparsedPath, "/");
            this.parentPath = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                this.parentPath[i] = stok.nextToken();
                ++i;
            }
            this.unparsedPath = null;
        }
        return this.parentPath;
    }

    public String getRootPath() {
        String[] path = this.getParentPath();
        if (path != null && path.length > 0) {
            return path[0];
        }
        return this.id;
    }

    public ArrayList getElements() {
        return this.elements;
    }

    public boolean hasElements() {
        if (this.elements != null) {
            return !this.elements.isEmpty();
        }
        return false;
    }
}

