/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.dialogs.InternalBase64Encoder;

class ZipFileResourceExporter {
    private ZipOutputStream outputStream;
    private StringBuffer manifestContents;
    private boolean generateManifestFile = false;
    private boolean useCompression = true;
    private static final String newline = "\r\n";
    private static final String manifestMagic = "Manifest-Version: 1.0\r\n\r\n";
    private static final String nameLabel = "Name: ";
    private static final String digestsLabel = "Digest-Algorithms: SHA MD5\r\n";
    private static final String shaLabel = "SHA-Digest: ";
    private static final String md5Label = "MD5-Digest: ";
    private static final String manifestPath = "meta-inf/Manifest.mf";

    public ZipFileResourceExporter(String filename, boolean compress, boolean includeManifestFile) throws IOException {
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
        this.generateManifestFile = includeManifestFile;
        if (this.generateManifestFile) {
            this.manifestContents = new StringBuffer(manifestMagic);
        }
    }

    protected void appendToManifest(String pathname, IFile file) throws IOException, CoreException {
        StringBuffer manifestEntry = new StringBuffer();
        manifestEntry.append(nameLabel);
        manifestEntry.append(pathname);
        manifestEntry.append(newline);
        manifestEntry.append(digestsLabel);
        manifestEntry.append(shaLabel);
        byte[] fileContents = null;
        InputStream contentStream = file.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        int chunkSize = contentStream.available();
        StringBuffer buffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            buffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        fileContents = buffer.toString().getBytes();
        try {
            byte[] hashValue = MessageDigest.getInstance("SHA").digest(fileContents);
            manifestEntry.append(InternalBase64Encoder.encode(hashValue));
            manifestEntry.append(newline);
            manifestEntry.append(md5Label);
            hashValue = MessageDigest.getInstance("MD5").digest(fileContents);
            manifestEntry.append(InternalBase64Encoder.encode(hashValue));
            manifestEntry.append("\r\n\r\n");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
        this.manifestContents.append(manifestEntry.toString());
    }

    public void finished() throws IOException {
        if (this.generateManifestFile) {
            this.writeManifestFile();
        }
        this.outputStream.close();
    }

    protected void write(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ByteArrayOutputStream output = null;
        InputStream contentStream = null;
        try {
            output = new ByteArrayOutputStream();
            contentStream = resource.getContents(false);
            int chunkSize = contentStream.available();
            byte[] readBuffer = new byte[chunkSize];
            int n = contentStream.read(readBuffer);
            while (n > 0) {
                output.write(readBuffer);
                n = contentStream.read(readBuffer);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (output != null) {
                output.close();
            }
            if (contentStream != null) {
                contentStream.close();
            }
            throw throwable;
        }
        Object var8_10 = null;
        if (output != null) {
            output.close();
        }
        if (contentStream != null) {
            contentStream.close();
        }
        this.write(destinationPath, output.toByteArray());
        if (this.generateManifestFile) {
            this.appendToManifest(destinationPath, resource);
        }
    }

    protected void writeManifestFile() throws IOException {
        this.write(manifestPath, this.manifestContents.toString().getBytes());
    }
}

