/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.dialogs.ListContentProvider;
import org.eclipse.ui.internal.dialogs.WorkingSetNewWizard;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class WorkingSetSelectionDialog
extends SelectionDialog
implements IWorkingSetSelectionDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider = new ListContentProvider();
    private TableViewer listViewer;
    private Button newButton;
    private Button detailsButton;
    private Button removeButton;
    private IWorkingSet[] result;
    private boolean multiSelect;
    private List addedWorkingSets;
    private List removedWorkingSets;
    private Map editedWorkingSets;

    public WorkingSetSelectionDialog(Shell parentShell, boolean multi) {
        super(parentShell);
        this.labelProvider = new WorkingSetLabelProvider();
        this.multiSelect = multi;
        if (this.multiSelect) {
            this.setTitle(WorkbenchMessages.getString("WorkingSetSelectionDialog.title.multiSelect"));
            this.setMessage(WorkbenchMessages.getString("WorkingSetSelectionDialog.message.multiSelect"));
        } else {
            this.setTitle(WorkbenchMessages.getString("WorkingSetSelectionDialog.title"));
            this.setMessage(WorkbenchMessages.getString("WorkingSetSelectionDialog.message"));
        }
    }

    private void addModifyButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        int id = 1025;
        this.newButton = this.createButton(buttonComposite, id++, WorkbenchMessages.getString("WorkingSetSelectionDialog.newButton.label"), false);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetSelectionDialog.this.createWorkingSet();
            }
        });
        this.detailsButton = this.createButton(buttonComposite, id++, WorkbenchMessages.getString("WorkingSetSelectionDialog.detailsButton.label"), false);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetSelectionDialog.this.editSelectedWorkingSet();
            }
        });
        this.removeButton = this.createButton(buttonComposite, id++, WorkbenchMessages.getString("WorkingSetSelectionDialog.removeButton.label"), false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetSelectionDialog.this.removeSelectedWorkingSets();
            }
        });
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.working_set_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = new TableViewer(composite, 2050);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetSelectionDialog.this.handleSelectionChanged();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorkingSetSelectionDialog.this.okPressed();
            }
        });
        this.addModifyButtons(composite);
        this.listViewer.setInput(Arrays.asList(WorkbenchPlugin.getDefault().getWorkingSetManager().getWorkingSets()));
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        List selections = this.getInitialElementSelections();
        if (!selections.isEmpty()) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(selections), true);
        }
        this.updateButtonAvailability();
        this.getOkButton().setEnabled(false);
        return control;
    }

    private void createWorkingSet() {
        WorkingSetNewWizard wizard = new WorkingSetNewWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.working_set_new_wizard_context");
        if (dialog.open() == 0) {
            IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
            IWorkingSet workingSet = wizard.getSelection();
            this.listViewer.add((Object)workingSet);
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet), true);
            manager.addWorkingSet(workingSet);
            this.addedWorkingSets.add(workingSet);
        }
    }

    private void editSelectedWorkingSet() {
        boolean firstEdit;
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        IWorkingSet editWorkingSet = (IWorkingSet)this.getSelectedWorkingSets().get(0);
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(editWorkingSet);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        IWorkingSet originalWorkingSet = (IWorkingSet)this.editedWorkingSets.get(editWorkingSet);
        boolean bl = firstEdit = originalWorkingSet == null;
        if (firstEdit) {
            originalWorkingSet = new WorkingSet(editWorkingSet.getName(), editWorkingSet.getElements());
        } else {
            this.editedWorkingSets.remove(editWorkingSet);
        }
        dialog.create();
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.working_set_edit_wizard_context");
        if (dialog.open() == 0) {
            editWorkingSet = wizard.getSelection();
            this.listViewer.update((Object)editWorkingSet, null);
        }
        this.editedWorkingSets.put(editWorkingSet, originalWorkingSet);
    }

    public IWorkingSet[] getSelection() {
        return this.result;
    }

    private List getSelectedWorkingSets() {
        ISelection selection = this.listViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return null;
    }

    private void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    protected void okPressed() {
        List newResult = this.getSelectedWorkingSets();
        this.result = newResult.toArray(new IWorkingSet[newResult.size()]);
        this.setResult(newResult);
        super.okPressed();
    }

    public int open() {
        this.addedWorkingSets = new ArrayList();
        this.removedWorkingSets = new ArrayList();
        this.editedWorkingSets = new HashMap();
        return super.open();
    }

    private void removeSelectedWorkingSets() {
        ISelection selection = this.listViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IWorkingSet workingSet = (IWorkingSet)iter.next();
                manager.removeWorkingSet(workingSet);
                if (this.addedWorkingSets.contains(workingSet)) {
                    this.addedWorkingSets.remove(workingSet);
                    continue;
                }
                this.removedWorkingSets.add(workingSet);
            }
            this.listViewer.remove(((IStructuredSelection)selection).toArray());
        }
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator iterator = this.addedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.removeWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        Iterator iterator = this.editedWorkingSets.keySet().iterator();
        while (iterator.hasNext()) {
            IWorkingSet editedWorkingSet = (IWorkingSet)iterator.next();
            IWorkingSet originalWorkingSet = (IWorkingSet)this.editedWorkingSets.get(editedWorkingSet);
            if (!editedWorkingSet.getName().equals(originalWorkingSet.getName())) {
                editedWorkingSet.setName(originalWorkingSet.getName());
            }
            if (editedWorkingSet.getElements().equals(originalWorkingSet.getElements())) continue;
            editedWorkingSet.setElements(originalWorkingSet.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator iterator = this.removedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.addWorkingSet((IWorkingSet)iterator.next());
        }
    }

    public void setSelection(IWorkingSet[] workingSets) {
        this.result = workingSets;
        this.setInitialSelections(workingSets);
    }

    private void updateButtonAvailability() {
        boolean hasSelection;
        ISelection selection = this.listViewer.getSelection();
        boolean hasSingleSelection = hasSelection = selection != null && !selection.isEmpty();
        this.removeButton.setEnabled(hasSelection);
        if (hasSelection && selection instanceof IStructuredSelection) {
            hasSingleSelection = ((IStructuredSelection)selection).size() == 1;
        }
        this.detailsButton.setEnabled(hasSingleSelection);
        if (!this.multiSelect) {
            this.getOkButton().setEnabled(!hasSelection || hasSingleSelection);
        } else {
            this.getOkButton().setEnabled(true);
        }
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map icons = new Hashtable();

        public void dispose() {
            Iterator iterator = this.icons.values().iterator();
            while (iterator.hasNext()) {
                Image icon = (Image)iterator.next();
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
            WorkingSetDescriptor descriptor = registry.getWorkingSetDescriptor(workingSet.getId());
            if (descriptor == null) {
                return null;
            }
            ImageDescriptor imageDescriptor = descriptor.getIcon();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = (Image)this.icons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.icons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            return workingSet.getName();
        }
    }
}

