/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.model.AdaptableList;

public class WizardCollectionElement
extends AdaptableList {
    private String id;
    private String name;
    private WizardCollectionElement parent;
    private AdaptableList wizards = new AdaptableList();
    static /* synthetic */ Class class$0;

    public WizardCollectionElement(String id, String name, WizardCollectionElement parent) {
        this.name = name;
        this.id = id;
        this.parent = parent;
    }

    public AdaptableList add(IAdaptable a) {
        if (a instanceof WorkbenchWizardElement) {
            this.wizards.add(a);
        } else {
            super.add(a);
        }
        return this;
    }

    public WizardCollectionElement findChildCollection(IPath searchPath) {
        Object[] children = this.getChildren(null);
        String searchString = searchPath.segment(0);
        int i = 0;
        while (i < children.length) {
            WizardCollectionElement currentCategory = (WizardCollectionElement)children[i];
            if (currentCategory.getLabel(null).equals(searchString)) {
                if (searchPath.segmentCount() == 1) {
                    return currentCategory;
                }
                return currentCategory.findChildCollection(searchPath.removeFirstSegments(1));
            }
            ++i;
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String searchId, boolean recursive) {
        Object[] wizards = this.getWizards();
        int i = 0;
        while (i < wizards.length) {
            WorkbenchWizardElement currentWizard = (WorkbenchWizardElement)wizards[i];
            if (currentWizard.getID().equals(searchId)) {
                return currentWizard;
            }
            ++i;
        }
        if (!recursive) {
            return null;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            WizardCollectionElement child = (WizardCollectionElement)iterator.next();
            WorkbenchWizardElement result = child.findWizard(searchId, true);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public IPath getPath() {
        if (this.parent == null) {
            return new Path("");
        }
        return this.parent.getPath().append(this.name);
    }

    public Object[] getWizards() {
        return this.wizards.getChildren();
    }

    public boolean isEmpty() {
        return this.size() == 0 && this.wizards.size() == 0;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setWizards(AdaptableList value) {
        this.wizards = value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("WizardCollection, ");
        buf.append(this.children.size());
        buf.append(" children, ");
        buf.append(this.wizards.size());
        buf.append(" wizards");
        return buf.toString();
    }
}

