/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PerspContentProvider;
import org.eclipse.ui.internal.dialogs.PerspLabelProvider;
import org.eclipse.ui.internal.registry.IViewDescriptor;

public class SelectPerspectiveDialog
extends Dialog
implements ISelectionChangedListener {
    private TableViewer list;
    private IPerspectiveRegistry perspReg;
    private IViewDescriptor selection;
    private IPerspectiveDescriptor perspDesc;
    private Button okButton;
    private Button cancelButton;
    private static final int LIST_WIDTH = 200;
    private static final int LIST_HEIGHT = 200;

    public SelectPerspectiveDialog(Shell parentShell, IPerspectiveRegistry perspReg) {
        super(parentShell);
        this.perspReg = perspReg;
    }

    protected void cancelPressed() {
        this.perspDesc = null;
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("SelectPerspective.shellTitle"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.select_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.list = new TableViewer(composite, 2816);
        this.list.getTable().setFont(parent.getFont());
        this.list.setLabelProvider((IBaseLabelProvider)new PerspLabelProvider());
        this.list.setContentProvider((IContentProvider)new PerspContentProvider());
        this.list.setSorter(new ViewerSorter(){});
        this.list.setInput((Object)this.perspReg);
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectPerspectiveDialog.this.handleDoubleClickEvent();
            }
        });
        Control ctrl = this.list.getControl();
        GridData spec = new GridData(1808);
        spec.widthHint = 200;
        spec.heightHint = 200;
        ctrl.setLayoutData((Object)spec);
        ctrl.setFont(parent.getFont());
        return composite;
    }

    public IPerspectiveDescriptor getSelection() {
        return this.perspDesc;
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection() {
        Object obj;
        this.perspDesc = null;
        IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
        if (!sel.isEmpty() && (obj = sel.getFirstElement()) instanceof IPerspectiveDescriptor) {
            this.perspDesc = (IPerspectiveDescriptor)obj;
        }
    }
}

