/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.misc.Sorter;
import org.eclipse.ui.internal.registry.PropertyPagesRegistryReader;

public class PropertyPageContributorManager
extends ObjectContributorManager {
    private static PropertyPageContributorManager sharedInstance = null;
    private boolean contributorsLoaded = false;
    private Sorter sorter = new Sorter(){
        private Collator collator = Collator.getInstance();

        public boolean compare(Object o1, Object o2) {
            RegistryPageContributor c1 = (RegistryPageContributor)o1;
            RegistryPageContributor c2 = (RegistryPageContributor)o2;
            if ("org.eclipse.ui.propertypages.info.file".equals(c1.getPageId())) {
                return !"org.eclipse.ui.propertypages.info.file".equals(c2.getPageId());
            }
            if ("org.eclipse.ui.propertypages.info.file".equals(c2.getPageId())) {
                return false;
            }
            String s1 = c1.getPageName();
            String s2 = c2.getPageName();
            return this.collator.compare(s2, s1) > 0;
        }
    };

    public boolean contribute(PropertyPageManager manager, IAdaptable object) {
        List result;
        if (!this.contributorsLoaded) {
            this.loadContributors();
        }
        if ((result = this.getContributors(object)) == null || result.size() == 0) {
            return false;
        }
        Object[] sortedResult = this.sorter.sort(result.toArray());
        boolean actualContributions = false;
        int i = 0;
        while (i < sortedResult.length) {
            IPropertyPageContributor ppcont = (IPropertyPageContributor)sortedResult[i];
            if (ppcont.isApplicableTo(object) && ppcont.contributePropertyPages(manager, object)) {
                actualContributions = true;
            }
            ++i;
        }
        return actualContributions;
    }

    public static PropertyPageContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new PropertyPageContributorManager();
        }
        return sharedInstance;
    }

    public boolean hasContributorsFor(Object object) {
        if (!this.contributorsLoaded) {
            this.loadContributors();
        }
        return super.hasContributorsFor(object);
    }

    private void loadContributors() {
        PropertyPagesRegistryReader reader = new PropertyPagesRegistryReader(this);
        reader.registerPropertyPages(Platform.getPluginRegistry());
        this.contributorsLoaded = true;
    }
}

