/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.MultiStepWizardDialog;
import org.eclipse.ui.internal.dialogs.UpdateProjectCapabilityWizard;
import org.eclipse.ui.internal.misc.ProjectCapabilitySelectionGroup;
import org.eclipse.ui.internal.registry.Capability;
import org.eclipse.ui.internal.registry.CapabilityRegistry;
import org.eclipse.ui.internal.registry.ICategory;

public class ProjectCapabilityPropertyPage
extends PropertyPage {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IProject project;
    private ProjectCapabilitySelectionGroup capabilityGroup;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.project_capability_property_page_context");
        this.noDefaultAndApplyButton();
        CapabilityRegistry reg = WorkbenchPlugin.getDefault().getCapabilityRegistry();
        String instructions = reg.hasCapabilities() ? WorkbenchMessages.getString("ProjectCapabilityPropertyPage.chooseCapabilities") : WorkbenchMessages.getString("ProjectCapabilityPropertyPage.noCapabilities");
        Label label = new Label(parent, 16384);
        label.setFont(parent.getFont());
        label.setText(instructions);
        Capability[] caps = reg.getProjectCapabilities(this.getProject());
        Capability[] disabledCaps = reg.getProjectDisabledCapabilities(this.getProject());
        ICategory[] cats = new ICategory[]{};
        this.capabilityGroup = new ProjectCapabilitySelectionGroup(cats, caps, disabledCaps, reg);
        return this.capabilityGroup.createContents(parent);
    }

    IProject getProject() {
        if (this.project == null) {
            IAdaptable iAdaptable = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.project = (IProject)iAdaptable.getAdapter((Class)clazz);
        }
        return this.project;
    }

    public boolean performOk() {
        String[] natureIds;
        Capability[] caps;
        if (!this.capabilityGroup.getCapabilitiesModified()) {
            return true;
        }
        CapabilityRegistry reg = WorkbenchPlugin.getDefault().getCapabilityRegistry();
        IStatus status = reg.validateCapabilities(caps = this.capabilityGroup.getSelectedCapabilities());
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("ProjectCapabilityPropertyPage.errorTitle"), (String)WorkbenchMessages.getString("ProjectCapabilityPropertyPage.invalidSelection"), (IStatus)status);
            return true;
        }
        try {
            natureIds = this.getProject().getDescription().getNatureIds();
            natureIds = this.getProject().getWorkspace().sortNatureSet(natureIds);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("ProjectCapabilityPropertyPage.errorTitle"), (String)WorkbenchMessages.getString("ProjectCapabilityPropertyPage.internalError"), (IStatus)e.getStatus());
            return true;
        }
        ArrayList<String> keepIds = new ArrayList<String>();
        ArrayList<Capability> removeCaps = new ArrayList<Capability>();
        int i = 0;
        while (i < natureIds.length) {
            boolean isRemoved = true;
            String id = natureIds[i];
            int j = 0;
            while (j < caps.length) {
                if (id.equals(caps[j].getNatureId())) {
                    keepIds.add(id);
                    isRemoved = false;
                    break;
                }
                ++j;
            }
            if (isRemoved) {
                removeCaps.add(reg.getCapabilityForNature(id));
            }
            ++i;
        }
        ArrayList<Capability> newCaps = new ArrayList<Capability>();
        int i2 = 0;
        while (i2 < caps.length) {
            boolean isNew = true;
            Capability cap = caps[i2];
            int j = 0;
            while (j < natureIds.length) {
                if (natureIds[j].equals(cap.getNatureId())) {
                    isNew = false;
                    break;
                }
                ++j;
            }
            if (isNew) {
                newCaps.add(cap);
            }
            ++i2;
        }
        if (newCaps.size() > 0 || removeCaps.size() > 0) {
            Capability[] newCapabilities = new Capability[newCaps.size()];
            newCaps.toArray(newCapabilities);
            Capability[] removeCapabilities = new Capability[removeCaps.size()];
            removeCaps.toArray(removeCapabilities);
            UpdateProjectCapabilityWizard wizard = new UpdateProjectCapabilityWizard(this.getProject(), newCapabilities, removeCapabilities);
            MultiStepWizardDialog dialog = new MultiStepWizardDialog(this.getShell(), wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
            WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.update_capability_wizard_context");
            dialog.open();
        }
        return true;
    }
}

