/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;

public class NewWizard
extends Wizard {
    private static final String CATEGORY_SEPARATOR = "/";
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewWizardSelectionPage mainPage;
    private boolean projectsOnly = false;
    private String categoryId = null;

    public void addPages() {
        NewWizardsRegistryReader rdr = new NewWizardsRegistryReader(this.projectsOnly);
        WizardCollectionElement wizards = (WizardCollectionElement)rdr.getWizards();
        if (this.categoryId != null) {
            WizardCollectionElement categories = wizards;
            StringTokenizer familyTokenizer = new StringTokenizer(this.categoryId, CATEGORY_SEPARATOR);
            while (familyTokenizer.hasMoreElements()) {
                if ((categories = this.getChildWithID(categories, familyTokenizer.nextToken())) == null) break;
            }
            if (categories != null) {
                wizards = categories;
            }
        }
        this.mainPage = new NewWizardSelectionPage(this.workbench, this.selection, wizards);
        this.addPage((IWizardPage)this.mainPage);
    }

    private WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++i;
        }
        return null;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String id) {
        this.categoryId = id;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        if (this.projectsOnly) {
            this.setWindowTitle(WorkbenchMessages.getString("NewProject.title"));
        } else {
            this.setWindowTitle(WorkbenchMessages.getString("NewWizard.title"));
        }
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_NEW_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.mainPage.saveWidgetValues();
        return true;
    }

    public void setProjectsOnly(boolean b) {
        this.projectsOnly = b;
    }
}

