/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.CreateProjectStep;
import org.eclipse.ui.internal.dialogs.InstallCapabilityStep;
import org.eclipse.ui.internal.dialogs.MultiStepCapabilityWizard;
import org.eclipse.ui.internal.dialogs.WizardNewProjectCapabilityPage;
import org.eclipse.ui.internal.dialogs.WizardNewProjectNameAndLocationPage;
import org.eclipse.ui.internal.dialogs.WizardStep;
import org.eclipse.ui.internal.registry.Capability;
import org.eclipse.ui.internal.registry.CapabilityRegistry;
import org.eclipse.ui.internal.registry.ICategory;

public class NewProjectWizard
extends MultiStepCapabilityWizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardNewProjectNameAndLocationPage creationPage;
    private WizardNewProjectCapabilityPage capabilityPage;
    private IProject newProject;
    private String initialProjectName;
    private Capability[] initialProjectCapabilities;
    private ICategory[] initialSelectedCategories;

    public NewProjectWizard() {
        WorkbenchPlugin plugin = WorkbenchPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewProjectWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewProjectWizard");
        }
        this.setDialogSettings(section);
    }

    protected void addCustomPages() {
        this.creationPage = new WizardNewProjectNameAndLocationPage("newProjectCreationPage");
        this.creationPage.setTitle(WorkbenchMessages.getString("NewProjectWizard.title"));
        this.creationPage.setDescription(WorkbenchMessages.getString("WizardNewProjectCreationPage.description"));
        this.creationPage.setInitialProjectName(this.initialProjectName);
        this.addPage((IWizardPage)this.creationPage);
        this.capabilityPage = new WizardNewProjectCapabilityPage("newProjectCapabilityPage");
        this.capabilityPage.setTitle(WorkbenchMessages.getString("NewProjectWizard.title"));
        this.capabilityPage.setDescription(WorkbenchMessages.getString("WizardNewProjectCapabilityPage.description"));
        this.capabilityPage.setInitialProjectCapabilities(this.initialProjectCapabilities);
        this.capabilityPage.setInitialSelectedCategories(this.initialSelectedCategories);
        this.addPage((IWizardPage)this.capabilityPage);
    }

    private boolean buildSteps() {
        Capability[] caps = this.capabilityPage.getSelectedCapabilities();
        CapabilityRegistry reg = WorkbenchPlugin.getDefault().getCapabilityRegistry();
        IStatus status = reg.validateCapabilities(caps);
        if (status.isOK()) {
            Capability[] results = reg.pruneCapabilities(caps);
            WizardStep[] steps = new WizardStep[results.length + 1];
            steps[0] = new CreateProjectStep(1, this.creationPage, this);
            int i = 0;
            while (i < results.length) {
                steps[i + 1] = new InstallCapabilityStep(i + 2, results[i], this.workbench, this);
                ++i;
            }
            this.setSteps(steps);
            return true;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("NewProjectWizard.errorTitle"), (String)WorkbenchMessages.getString("NewProjectWizard.invalidCapabilities"), (IStatus)status);
        return false;
    }

    protected boolean canFinishOnReviewPage() {
        return this.getSteps().length == 1;
    }

    protected String getConfigurePageTitle() {
        return WorkbenchMessages.getString("NewProjectWizard.title");
    }

    protected String getConfigurePageDescription() {
        return WorkbenchMessages.getString("WizardProjectConfigurePage.description");
    }

    protected String getReviewPageTitle() {
        return WorkbenchMessages.getString("NewProjectWizard.title");
    }

    protected String getReviewPageDescription() {
        return WorkbenchMessages.getString("WizardProjectReviewPage.description");
    }

    protected String getFinishStepLabel(WizardStep[] steps) {
        if (steps.length > 2) {
            return super.getFinishStepLabel(steps);
        }
        return null;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    protected String[] getPerspectiveChoices() {
        ArrayList<String> results = new ArrayList<String>();
        Capability[] caps = this.capabilityPage.getSelectedCapabilities();
        int i = 0;
        while (i < caps.length) {
            ArrayList ids = caps[i].getPerspectiveChoices();
            if (ids != null) {
                Iterator iterator = ((AbstractList)ids).iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    if (results.contains(id)) continue;
                    results.add(id);
                }
            }
            ++i;
        }
        String[] ids = new String[results.size()];
        results.toArray(ids);
        return ids;
    }

    public IProject getProject() {
        return this.newProject;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.capabilityPage && !this.buildSteps()) {
            return this.capabilityPage;
        }
        return super.getNextPage(page);
    }

    boolean handleMissingStepWizard(WizardStep step) {
        MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("NewProjectWizard.errorTitle"), (String)WorkbenchMessages.format("NewProjectWizard.noWizard", new Object[]{step.getLabel()}));
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
        this.setWindowTitle(WorkbenchMessages.getString("NewProjectWizard.windowTitle"));
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void setInitialSelectedCategories(ICategory[] categories) {
        this.initialSelectedCategories = categories;
    }

    public void setInitialProjectCapabilities(Capability[] capabilities) {
        this.initialProjectCapabilities = capabilities;
    }

    public void setInitialProjectName(String name) {
        this.initialProjectName = name == null ? null : name.trim();
    }

    void setNewProject(IProject project) {
        this.newProject = project;
    }
}

