/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class FileSystemResourceExporter {
    FileSystemResourceExporter() {
    }

    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++i;
            }
        }
    }

    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException {
        block6: {
            FileOutputStream output = null;
            InputStream contentStream = null;
            try {
                output = new FileOutputStream(destinationPath.toOSString());
                contentStream = file.getContents(false);
                int chunkSize = contentStream.available();
                byte[] readBuffer = new byte[chunkSize];
                int n = contentStream.read(readBuffer);
                while (n > 0) {
                    output.write(readBuffer);
                    n = contentStream.read(readBuffer);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (output != null) {
                    output.close();
                }
                if (contentStream != null) {
                    contentStream.close();
                }
                throw throwable;
            }
            Object var8_10 = null;
            if (output != null) {
                output.close();
            }
            if (contentStream == null) break block6;
            contentStream.close();
        }
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

