/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FakeActionSetCategory;
import org.eclipse.ui.internal.dialogs.FakePerspectiveActionSet;
import org.eclipse.ui.internal.dialogs.FakeViewActionSet;
import org.eclipse.ui.internal.dialogs.FakeWizardActionSet;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.ActionSetCategory;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;

public class ActionSetDialogInput {
    private ArrayList categories = new ArrayList(10);
    private static final String ID_VIEW = "org.eclipse.ui.views";
    private static final String ID_WIZARD = "org.eclipse.ui.wizards";
    private static final String ID_PERSP = "org.eclipse.ui.perspectives";
    private FakeActionSetCategory viewCat;
    private FakeActionSetCategory perspCat;
    private FakeActionSetCategory wizardCat;

    public ActionSetDialogInput() {
        this.initActionSets();
        this.initViews();
        this.initNewWizards();
        this.initPerspectives();
    }

    private void addActionSets(Object[] cats) {
        int nX = 0;
        while (nX < cats.length) {
            WizardCollectionElement cat = (WizardCollectionElement)cats[nX];
            Object[] wizards = cat.getWizards();
            int nY = 0;
            while (nY < wizards.length) {
                WorkbenchWizardElement wiz = (WorkbenchWizardElement)wizards[nY];
                FakeWizardActionSet actionSet = new FakeWizardActionSet(wiz);
                this.wizardCat.addActionSet(actionSet);
                ++nY;
            }
            Object[] subCats = cat.getChildren();
            this.addActionSets(subCats);
            ++nX;
        }
    }

    public ActionSetCategory findCategory(String id) {
        if (id == null) {
            return null;
        }
        Iterator iter = ((AbstractList)this.categories).iterator();
        while (iter.hasNext()) {
            ActionSetCategory cat = (ActionSetCategory)iter.next();
            if (!cat.getId().equals(id)) continue;
            return cat;
        }
        return null;
    }

    public Object[] getCategories() {
        return this.categories.toArray();
    }

    public FakePerspectiveActionSet getPerspectiveActionSet(String id) {
        return (FakePerspectiveActionSet)this.perspCat.findActionSet(id);
    }

    public FakeViewActionSet getViewActionSet(String id) {
        return (FakeViewActionSet)this.viewCat.findActionSet(id);
    }

    public FakeWizardActionSet getWizardActionSet(String id) {
        return (FakeWizardActionSet)this.wizardCat.findActionSet(id);
    }

    private void initActionSets() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        ActionSetCategory[] cats = reg.getCategories();
        int nX = 0;
        while (nX < cats.length) {
            this.categories.add(cats[nX]);
            ++nX;
        }
    }

    private void initNewWizards() {
        this.wizardCat = new FakeActionSetCategory(ID_WIZARD, WorkbenchMessages.getString("ActionSetDialogInput.wizardCategory"));
        this.categories.add(this.wizardCat);
        NewWizardsRegistryReader rdr = new NewWizardsRegistryReader();
        WizardCollectionElement wizardCollection = (WizardCollectionElement)rdr.getWizards();
        Object[] cats = wizardCollection.getChildren();
        this.addActionSets(cats);
    }

    private void initPerspectives() {
        this.perspCat = new FakeActionSetCategory(ID_PERSP, WorkbenchMessages.getString("ActionSetDialogInput.perspectiveCategory"));
        this.categories.add(this.perspCat);
        IPerspectiveRegistry perspReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IPerspectiveDescriptor[] persps = perspReg.getPerspectives();
        int nX = 0;
        while (nX < persps.length) {
            FakePerspectiveActionSet actionSet = new FakePerspectiveActionSet(persps[nX]);
            this.perspCat.addActionSet(actionSet);
            ++nX;
        }
    }

    private void initViews() {
        this.viewCat = new FakeActionSetCategory(ID_VIEW, WorkbenchMessages.getString("ActionSetDialogInput.viewCategory"));
        this.categories.add(this.viewCat);
        IViewRegistry viewReg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor[] views = viewReg.getViews();
        int nX = 0;
        while (nX < views.length) {
            FakeViewActionSet actionSet = new FakeViewActionSet(views[nX]);
            this.viewCat.addActionSet(actionSet);
            ++nX;
        }
    }
}

